/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.AlertTypeDto;
import com.zhyc.xps.aqpt.entity.AlertType;
import com.zhyc.xps.aqpt.service.AlertTypeService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alert/type"})
public class AlertTypeController
extends BaseController {
    @Resource
    AlertTypeService alertTypeService;

    @GetMapping(value={""})
    public JsonResult getAlertTypeByList(@RequestParam Map<String, Object> map) {
        List<AlertTypeDto> data = this.alertTypeService.getAlertTypeByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAlertTypeByPage(@RequestParam Map<String, Object> map) {
        PageBean<AlertTypeDto> pageInfo = this.alertTypeService.getAlertTypeByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{alertTypeId}"})
    public JsonResult getAlertTypeById(@PathVariable Long alertTypeId) {
        AlertTypeDto data = this.alertTypeService.getAlertTypeById(alertTypeId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAlertType(@RequestBody AlertType alertType) {
        Long userId = this.getCurUserId();
        try {
            alertType.setCreatedBy(userId);
            this.alertTypeService.createAlertType(alertType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAlertType(@RequestBody AlertType alertType) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            alertType.setUpdatedBy(userId);
            this.alertTypeService.updateAlertType(alertType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{alertTypeId}"})
    public JsonResult deleteAlertTypeById(@PathVariable Long alertTypeId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("alertTypeId", alertTypeId);
            map.put("deletedBy", userId);
            this.alertTypeService.deleteAlertType(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

