/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.CheckCatDto;
import com.zhyc.xps.aqpt.entity.CheckCat;
import com.zhyc.xps.aqpt.service.CheckCatService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/cat"})
public class CheckCatController
extends BaseController {
    @Resource
    CheckCatService checkCatService;

    @GetMapping(value={""})
    public JsonResult getCheckCatByList(@RequestParam Map<String, Object> map) {
        List<CheckCatDto> data = this.checkCatService.getCheckCatByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getCheckCatByPage(@RequestParam Map<String, Object> map) {
        PageBean<CheckCatDto> pageInfo = this.checkCatService.getCheckCatByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{checkCatId}"})
    public JsonResult getCheckCatById(@PathVariable Long checkCatId) {
        Long ocId = this.getCurOcId();
        CheckCatDto data = this.checkCatService.getCheckCatById(ocId, checkCatId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createCheckCat(@RequestBody CheckCat checkCat) {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            checkCat.setOcId(ocId);
            checkCat.setCreatedBy(userId);
            this.checkCatService.createCheckCat(checkCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateCheckCat(@RequestBody CheckCat checkCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            checkCat.setOcId(ocId);
            checkCat.setUpdatedBy(userId);
            this.checkCatService.updateCheckCat(checkCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{checkCatId}"})
    public JsonResult deleteCheckCatById(@PathVariable Long checkCatId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("checkCatId", checkCatId);
            map.put("deletedBy", userId);
            this.checkCatService.deleteCheckCat(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

