/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.zhyc.xps.aqpt.dto.CheckRecordDto;
import com.zhyc.xps.aqpt.entity.CheckRecord;
import com.zhyc.xps.aqpt.service.CheckRecordEventService;
import com.zhyc.xps.aqpt.service.CheckRecordService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/record"})
public class CheckRecordController
extends BaseController {
    @Resource
    CheckRecordService checkRecordService;
    @Resource
    CheckRecordEventService checkRecordEventService;

    @GetMapping(value={""})
    public JsonResult getCheckRecordByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<CheckRecordDto> data = this.checkRecordService.getCheckRecordByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getCheckRecordByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<CheckRecordDto> data = this.checkRecordService.getCheckRecordByPage(map);
        return this.pageResult(data);
    }

    @DeleteMapping(value={"/{checkRecordId}"})
    public JsonResult deleteCheckRecordById(@PathVariable Long checkRecordId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.checkRecordService.deleteCheckRecordById(ocId, checkRecordId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"/create"})
    public JsonResult createCheckRecordByScan(@RequestBody Map<String, Object> map) throws CustomException {
        JSONObject json = new JSONObject(map);
        CheckRecord checkRecord = (CheckRecord)((Object)json.to(CheckRecord.class, new JSONReader.Feature[0]));
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long groupId = this.getCurUserGroupId();
        Long positionId = this.getCurUserPositionId();
        try {
            checkRecord.setOcId(ocId);
            checkRecord.setGroupId(groupId);
            checkRecord.setPositionId(positionId);
            checkRecord.setAccountId(userId);
            this.checkRecordService.createCheckRecord(checkRecord);
            if (checkRecord.getCheckResult() == 1L) return this.resultOk("\u4fdd\u5b58\u6210\u529f");
            this.checkRecordEventService.createCheckRecordEvent(checkRecord);
            if (checkRecord.getCheckResult() != 3L) return this.resultOk("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }
}

