/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.CheckTaskDto;
import com.zhyc.xps.aqpt.service.CheckTaskService;
import com.zhyc.xps.aqpt.vo.CheckTaskVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.vo.TaskUserVo;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/task"})
public class CheckTaskController
extends BaseController {
    @Resource
    CheckTaskService checkTaskService;

    @GetMapping(value={"/page"})
    public PageResult getCheckTaskByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<CheckTaskDto> data = this.checkTaskService.getCheckTaskByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getCheckTaskByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<CheckTaskDto> data = this.checkTaskService.getCheckTaskByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{taskId}"})
    public JsonResult getCheckTaskById(@PathVariable Long taskId) {
        Long ocId = this.getCurOcId();
        CheckTaskDto task = this.checkTaskService.getCheckTaskById(ocId, taskId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", task);
    }

    @GetMapping(value={"/view/{taskId}"})
    public JsonResult getCheckTaskViewById(@PathVariable Long taskId) {
        Long ocId = this.getCurOcId();
        CheckTaskVo task = this.checkTaskService.getCheckTaskViewById(ocId, taskId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", task);
    }

    @PutMapping(value={"/handle/{taskId}"})
    public JsonResult handleCheckTask(@PathVariable Long taskId) throws CustomException {
        CheckTaskVo data;
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setAccountId(userId);
        user.setPositionId(positionId);
        user.setGroupId(groupId);
        try {
            data = this.checkTaskService.handleTask(taskId, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PutMapping(value={"/transfer"})
    public JsonResult transferCheckTask(@RequestBody TaskUserVo userTo) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        Long taskId = userTo.getTaskId();
        TaskUserVo userFr = new TaskUserVo();
        userFr.setOcId(ocId);
        userFr.setTaskId(taskId);
        userFr.setAccountId(userId);
        userFr.setPositionId(positionId);
        userFr.setGroupId(groupId);
        try {
            this.checkTaskService.transferTask(taskId, userFr, userTo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f");
    }

    @PutMapping(value={"/complete/{taskId}"})
    public JsonResult completeCheckTask(@PathVariable Long taskId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setTaskId(taskId);
        user.setAccountId(userId);
        user.setPositionId(positionId);
        user.setGroupId(groupId);
        try {
            this.checkTaskService.completeTask(taskId, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f");
    }

    @PutMapping(value={"/cancel/{taskId}"})
    public JsonResult cancelCheckTask(@PathVariable Long taskId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setTaskId(taskId);
        user.setAccountId(userId);
        user.setPositionId(positionId);
        user.setGroupId(groupId);
        try {
            this.checkTaskService.cancelTask(taskId, user);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"/once/add"})
    public JsonResult createOnceCheckTask(@RequestBody CheckTaskDto checkTaskDto) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        Long taskId = checkTaskDto.getTaskId();
        TaskUserVo userFr = new TaskUserVo();
        userFr.setOcId(ocId);
        userFr.setTaskId(taskId);
        userFr.setAccountId(userId);
        userFr.setPositionId(positionId);
        userFr.setGroupId(groupId);
        checkTaskDto.setOcId(ocId);
        checkTaskDto.setCreatedBy(this.getCurUserId());
        try {
            this.checkTaskService.createOnceCheckTask(checkTaskDto, userFr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/quick/add"})
    public JsonResult createQuickCheckTask(@RequestBody CheckTaskDto checkTaskDto) throws CustomException {
        CheckTaskVo data;
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        Long taskId = checkTaskDto.getTaskId();
        TaskUserVo userFr = new TaskUserVo();
        userFr.setOcId(ocId);
        userFr.setTaskId(taskId);
        userFr.setAccountId(userId);
        userFr.setPositionId(positionId);
        userFr.setGroupId(groupId);
        checkTaskDto.setOcId(ocId);
        checkTaskDto.setCreatedBy(this.getCurUserId());
        try {
            data = this.checkTaskService.createQuickCheckTask(checkTaskDto, userFr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f", data);
    }

    @PutMapping(value={"/update"})
    public JsonResult updateCheckTask(@RequestBody CheckTaskDto checkTask) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        TaskUserVo userFr = new TaskUserVo();
        userFr.setOcId(ocId);
        userFr.setTaskId(checkTask.getTaskId());
        userFr.setAccountId(userId);
        userFr.setPositionId(positionId);
        userFr.setGroupId(groupId);
        try {
            checkTask.setOcId(ocId);
            checkTask.setUpdatedBy(userId);
            this.checkTaskService.updateCheckTask(checkTask, userFr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{taskId}"})
    public JsonResult deleteCheckTaskById(@PathVariable Long taskId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long positionId = this.getCurUserPositionId();
        Long groupId = this.getCurUserGroupId();
        TaskUserVo userFr = new TaskUserVo();
        userFr.setOcId(ocId);
        userFr.setTaskId(taskId);
        userFr.setAccountId(userId);
        userFr.setPositionId(positionId);
        userFr.setGroupId(groupId);
        try {
            this.checkTaskService.deleteCheckTaskById(taskId, userFr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

