/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.service.CheckTaskDoingService;
import com.zhyc.xps.aqpt.vo.CheckTaskDoingItemVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/task/doing/item"})
public class CheckTaskDoingController
extends BaseController {
    @Resource
    CheckTaskDoingService checkTaskDoingService;

    @GetMapping(value={"/{taskId}/{checkRecordId}"})
    public JsonResult getCheckTaskDoingItemById(@PathVariable Long taskId, @PathVariable Long checkRecordId) {
        Long ocId = this.getCurOcId();
        CheckTaskDoingItemVo vo = this.checkTaskDoingService.getCheckTaskDoingItemById(ocId, taskId, checkRecordId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }

    @PutMapping(value={"/update"})
    public JsonResult updateCheckTaskDoingItem(@RequestBody CheckTaskDoingItemVo item) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            item.setOcId(ocId);
            item.setAccountId(userId);
            item.setUpdatedBy(userId);
            this.checkTaskDoingService.updateCheckTaskDoingItem(item);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/verifyCheckTaskDoingIsComplete/{taskId}"})
    public JsonResult verifyCheckTaskDoingIsComplete(@PathVariable Long taskId) {
        Long ocId = this.getCurOcId();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("taskId", taskId);
        map.put("ocId", ocId);
        Boolean result = this.checkTaskDoingService.verifyCheckTaskDoingIsComplete(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", result);
    }

    @PutMapping(value={"/batchUpdate/{taskId}/{checkResult}"})
    public JsonResult batchUpdateCheckTaskDoingItem(@PathVariable Long taskId, @PathVariable Long checkResult) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            this.checkTaskDoingService.batchUpdateCheckTaskDoingItem(ocId, taskId, checkResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{taskId}/{checkRecordId}"})
    public JsonResult deleteCheckTaskDoingItemById(@PathVariable Long taskId, @PathVariable Long checkRecordId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.checkTaskDoingService.deleteCheckTaskDoingItemById(ocId, taskId, checkRecordId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

