/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.service.ChecklistHazardRiskService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checklist/hazard/risk"})
public class ChecklistHazardRiskController
extends BaseController {
    @Resource
    ChecklistHazardRiskService riskService;

    @GetMapping(value={"/{checklistId}/{hazardId}"})
    public JsonResult getRiskListByHazardId(@PathVariable Long checklistId, @PathVariable Long hazardId) {
        Long ocId = this.getCurOcId();
        List<ChecklistHazardRiskVo> data = this.riskService.getRiskByHazard(ocId, checklistId, hazardId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{checklistId}/{hazardId}/{riskId}"})
    public JsonResult getRiskById(@PathVariable Long checklistId, @PathVariable Long hazardId, @PathVariable Long riskId) {
        Long ocId = this.getCurOcId();
        ChecklistHazardRiskDto risk = this.riskService.getRiskById(ocId, checklistId, hazardId, riskId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", risk);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRisk(@RequestBody ChecklistHazardRiskDto risk) throws CustomException {
        Long ocId = this.getCurOcId();
        Long curUserId = this.getCurUserId();
        try {
            risk.setOcId(ocId);
            risk.setCreatedBy(curUserId);
            this.riskService.createRisk(risk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateRisk(@RequestBody ChecklistHazardRiskDto risk) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            risk.setOcId(ocId);
            risk.setUpdatedBy(userId);
            this.riskService.updateRisk(risk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/updateLevel/{checklistId}/{hazardId}/{riskId}/{riskLevel}"})
    public JsonResult updateRiskLevel(@PathVariable Long checklistId, @PathVariable Long hazardId, @PathVariable Long riskId, @PathVariable Long riskLevel) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.riskService.updateRiskLevel(ocId, checklistId, hazardId, riskId, riskLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{checklistId}/{hazardId}/{riskId}"})
    public JsonResult deleteRiskById(@PathVariable Long checklistId, @PathVariable Long hazardId, @PathVariable Long riskId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.riskService.deleteRiskById(ocId, checklistId, hazardId, riskId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

