/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.entity.EntCtrlLevel;
import com.zhyc.xps.aqpt.service.EntCtrlLevelService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/ctrlLevel"})
public class EntCtrlLevelController
extends BaseController {
    @Resource
    EntCtrlLevelService ctrlLevelService;

    @GetMapping(value={""})
    public JsonResult getCtrlLevelByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntCtrlLevel> data = this.ctrlLevelService.getCtrlLevelList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getCtrlLevelByPage(@RequestParam Map<String, Object> map) {
        PageBean<EntCtrlLevel> pageInfo = this.ctrlLevelService.getCtrlLevelByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/enabled"})
    public JsonResult getEnabledCtrlLevelList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntCtrlLevel> data = this.ctrlLevelService.getEnabledCtrlLevelList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{ctrlLevelId}"})
    public JsonResult getCtrlLevelById(@PathVariable Long ctrlLevelId) {
        Long ocId = this.getCurOcId();
        EntCtrlLevel ctrlLevel = this.ctrlLevelService.getCtrlLevelById(ocId, ctrlLevelId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)ctrlLevel);
    }

    @PostMapping(value={"/add"})
    public JsonResult createCtrlLevel(@RequestBody EntCtrlLevel ctrlLevel) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            ctrlLevel.setOcId(ocId);
            ctrlLevel.setCreatedBy(userId);
            this.ctrlLevelService.createCtrlLevel(ctrlLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateCtrlLevel(@RequestBody EntCtrlLevel ctrlLevel) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            ctrlLevel.setOcId(ocId);
            ctrlLevel.setUpdatedBy(userId);
            this.ctrlLevelService.updateCtrlLevel(ctrlLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/updateStatus/{ctrlLevelId}/{bEnabled}"})
    public JsonResult updateStatus(@PathVariable Long ctrlLevelId, @PathVariable Long bEnabled) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.ctrlLevelService.enableCtrlLevel(ocId, ctrlLevelId, bEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{ctrlLevelId}"})
    public JsonResult deleteCtrlLevelById(@PathVariable Long ctrlLevelId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.ctrlLevelService.deleteCtrlLevelById(ocId, ctrlLevelId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

