/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.entity.EntDangerCat;
import com.zhyc.xps.aqpt.service.EntDangerCatService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/danger/cat"})
public class EntDangerCatController
extends BaseController {
    @Resource
    EntDangerCatService dangerCatService;

    @GetMapping(value={"/page"})
    public PageResult getDangerCatByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntDangerCat> pageInfo = this.dangerCatService.getDangerCatByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={""})
    public JsonResult getDangerCatByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntDangerCat> data = this.dangerCatService.getDangerCatByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{dangerCatId}"})
    public JsonResult getDangerCatById(@PathVariable Long dangerCatId) {
        Long ocId = this.getCurOcId();
        EntDangerCat dangerCat = this.dangerCatService.getDangerCatById(ocId, dangerCatId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)dangerCat);
    }

    @PostMapping(value={"/add"})
    public JsonResult createDangerCat(@RequestBody EntDangerCat dangerCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            dangerCat.setOcId(ocId);
            dangerCat.setCreatedBy(userId);
            this.dangerCatService.createDangerCat(dangerCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateDangerCat(@RequestBody EntDangerCat dangerCat) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            dangerCat.setOcId(ocId);
            dangerCat.setUpdatedBy(userId);
            this.dangerCatService.updateDangerCat(dangerCat);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{dangerCatId}"})
    public JsonResult deleteDangerCatById(@PathVariable Long dangerCatId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.dangerCatService.deleteDangerCatById(ocId, dangerCatId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

