/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.service.EntDangerStatisService;
import com.zhyc.xps.aqpt.vo.DangerByCatVo;
import com.zhyc.xps.aqpt.vo.DangerByMonthVo;
import com.zhyc.xps.aqpt.vo.DangerCounterVo;
import com.zhyc.xps.aqpt.vo.DangerStatisVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.service.GroupService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/danger/statis"})
public class EntDangerStatisController
extends BaseController {
    @Resource
    EntDangerStatisService dangerStatisService;
    @Resource
    GroupService groupService;

    @GetMapping(value={"/getCounter"})
    public JsonResult getDangerStatisCounter() {
        Long ocId = this.getCurOcId();
        Long groupId = this.getCurUserGroupId();
        Long userId = this.getCurUserId();
        GroupDto group = this.groupService.getGroupById(ocId, groupId);
        if (ObjectUtils.isEmpty((Object)group)) {
            return this.resultErr("\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long groupLeft = group.getNodeLeft();
        Long groupRight = group.getNodeRight();
        DangerStatisVo statisVo = new DangerStatisVo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("submitAccountId", userId);
        int myCreated = this.dangerStatisService.counterByHandler(map);
        statisVo.setMyCreatedCount(myCreated);
        map.clear();
        map.put("ocId", ocId);
        map.put("curAccountId", userId);
        int myHandling = this.dangerStatisService.counterByHandler(map);
        statisVo.setMyHandlingCount(myHandling);
        map.clear();
        map.put("ocId", ocId);
        map.put("handleAccountId", userId);
        int myHandled = this.dangerStatisService.counterByHandler(map);
        statisVo.setMyHandledCount(myHandled);
        map.clear();
        map.put("ocId", ocId);
        map.put("submitAccountId", userId);
        map.put("status", -1);
        int myCanceled = this.dangerStatisService.counterByHandler(map);
        statisVo.setMyCanceledCount(myCanceled);
        map.clear();
        map.put("ocId", ocId);
        map.put("curGroupNodeLeft", groupLeft);
        map.put("curGroupNodeRight", groupRight);
        int groupHandling = this.dangerStatisService.counterByHandler(map);
        statisVo.setGroupHandlingCount(groupHandling);
        map.clear();
        map.put("ocId", ocId);
        map.put("submitGroupNodeLeft", groupLeft);
        map.put("submitGroupNodeRight", groupRight);
        int groupSubmit = this.dangerStatisService.counterByHandler(map);
        statisVo.setGroupSubmitCount(groupSubmit);
        map.clear();
        map.put("ocId", ocId);
        map.put("reviewGroupNodeLeft", groupLeft);
        map.put("reviewGroupNodeRight", groupRight);
        int groupReview = this.dangerStatisService.counterByHandler(map);
        statisVo.setGroupReviewCount(groupReview);
        map.clear();
        map.put("ocId", ocId);
        map.put("rectifyGroupNodeLeft", groupLeft);
        map.put("rectifyGroupNodeRight", groupRight);
        int groupRectify = this.dangerStatisService.counterByHandler(map);
        statisVo.setGroupRectifyCount(groupRectify);
        map.clear();
        map.put("ocId", ocId);
        map.put("acceptGroupNodeLeft", groupLeft);
        map.put("acceptGroupNodeRight", groupRight);
        int groupAccept = this.dangerStatisService.counterByHandler(map);
        statisVo.setGroupAcceptCount(groupAccept);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", statisVo);
    }

    @GetMapping(value={"/counterByStatus"})
    public JsonResult getCounterByStatus() {
        Long groupId;
        Long ocId = this.getCurOcId();
        GroupDto group = this.groupService.getGroupById(ocId, groupId = this.getCurUserGroupId());
        if (ObjectUtils.isEmpty((Object)group)) {
            return this.resultErr("\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long groupLeft = group.getNodeLeft();
        Long groupRight = group.getNodeRight();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("nodeLeft", groupLeft);
        map1.put("nodeRight", groupRight);
        DangerCounterVo vo1 = this.dangerStatisService.counterByStatus(map1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("handling", vo1.getHandling());
        map.put("total", vo1.getHandling() + vo1.getCompleted());
        return this.resultOk("\u83b7\u53d6\u6210\u529f", map);
    }

    @GetMapping(value={"/counterByCat"})
    public JsonResult getCounterByDangerCat() {
        Long ocId = this.getCurOcId();
        DangerByCatVo vo = this.dangerStatisService.counterByCat(ocId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }

    @GetMapping(value={"/counterByMonth/{year}"})
    public JsonResult getCounterByDangerMonth(@PathVariable String year) {
        Long ocId = this.getCurOcId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("year", year);
        DangerByMonthVo vo = this.dangerStatisService.counterByMonth(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }
}

