/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRiskMeasure;
import com.zhyc.xps.aqpt.service.ChecklistHazardRiskMeasureService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/hazard/risk/measure"})
public class EntHazardRiskMeasureController
extends BaseController {
    @Resource
    ChecklistHazardRiskMeasureService riskMeasureService;

    @GetMapping(value={"/page"})
    public PageResult getRiskMeasureByPage(@RequestParam Map<String, Object> map) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        PageBean<ChecklistHazardRiskMeasureDto> data = this.riskMeasureService.getMeasureByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getRiskMeasureByList(@RequestParam Map<String, Object> map) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        List<ChecklistHazardRiskMeasureDto> data = this.riskMeasureService.getMeasureByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{hazardId}/{riskId}/{measureId}"})
    public JsonResult getRiskMeasureById(@PathVariable Long hazardId, @PathVariable Long riskId, @PathVariable Long measureId) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        ChecklistHazardRiskMeasureDto riskMeasure = this.riskMeasureService.getMeasureById(ocId, checklistId, hazardId, riskId, measureId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", riskMeasure);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskMeasure(@RequestBody ChecklistHazardRiskMeasure riskMeasure) throws CustomException {
        Long ocId;
        Long curUserId = this.getCurUserId();
        Long checklistId = ocId = this.getCurOcId();
        try {
            riskMeasure.setOcId(ocId);
            riskMeasure.setChecklistId(checklistId);
            riskMeasure.setCreatedBy(curUserId);
            this.riskMeasureService.createMeasure(riskMeasure);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateRiskMeasure(@RequestBody ChecklistHazardRiskMeasure riskMeasure) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long checklistId = ocId;
        try {
            riskMeasure.setOcId(ocId);
            riskMeasure.setChecklistId(checklistId);
            riskMeasure.setUpdatedBy(userId);
            this.riskMeasureService.updateMeasure(riskMeasure);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{hazardId}/{riskId}/{measureId}"})
    public JsonResult deleteRiskMeasureById(@PathVariable Long hazardId, @PathVariable Long riskId, @PathVariable Long measureId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long checklistId = ocId;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("checklistId", checklistId);
            map.put("hazardId", hazardId);
            map.put("riskId", riskId);
            map.put("measureId", measureId);
            map.put("deletedBy", userId);
            this.riskMeasureService.deleteMeasure(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

