/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EntRiskPointDetailDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointDto;
import com.zhyc.xps.aqpt.entity.EntRiskPoint;
import com.zhyc.xps.aqpt.service.EntRiskPointService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint"})
public class EntRiskPointController
extends BaseController {
    @Resource
    EntRiskPointService riskPointService;

    @GetMapping(value={"/page"})
    public PageResult getRiskPointByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntRiskPointDto> data = this.riskPointService.getRiskPointByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getRiskPointByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntRiskPointDto> data = this.riskPointService.getRiskPointByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{riskPointId}"})
    public JsonResult getRiskPointById(@PathVariable Long riskPointId) {
        Long ocId = this.getCurOcId();
        EntRiskPointDto data = this.riskPointService.getRiskPointById(ocId, riskPointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/detail/{riskPointId}"})
    public JsonResult getRiskPointDetailById(@PathVariable Long riskPointId) {
        Long ocId = this.getCurOcId();
        EntRiskPointDetailDto data = this.riskPointService.getRiskPointDetailById(ocId, riskPointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPoint(@RequestBody EntRiskPoint riskPoint) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPoint.setOcId(ocId);
            riskPoint.setCreatedBy(userId);
            this.riskPointService.createRiskPoint(riskPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateRiskPoint(@RequestBody EntRiskPoint riskPoint) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPoint.setOcId(ocId);
            riskPoint.setUpdatedBy(userId);
            this.riskPointService.updateRiskPoint(riskPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/uploadImage"})
    public JsonResult updateRiskPointImage(@RequestBody EntRiskPoint riskPoint) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPoint.setOcId(ocId);
            riskPoint.setUpdatedBy(userId);
            this.riskPointService.updateRiskPoint(riskPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}"})
    public JsonResult deleteRiskPointById(@PathVariable Long riskPointId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            this.riskPointService.deleteRiskPointById(ocId, riskPointId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

