/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointHazardDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointHazard;
import com.zhyc.xps.aqpt.service.EntRiskPointHazardService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint/hazard"})
public class EntRiskPointHazardController
extends BaseController {
    @Resource
    EntRiskPointHazardService riskPointHazardService;

    @GetMapping(value={"/page"})
    public PageResult getRiskPointHazardByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", ocId);
        PageBean<EntRiskPointHazardDto> data = this.riskPointHazardService.getRiskPointHazardByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getRiskPointHazardByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", ocId);
        List<EntRiskPointHazardDto> data = this.riskPointHazardService.getRiskPointHazardByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPointHazard(@RequestBody EntRiskPointHazard riskPointHazard) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPointHazard.setOcId(ocId);
            riskPointHazard.setChecklistId(ocId);
            riskPointHazard.setCreatedBy(userId);
            this.riskPointHazardService.createRiskPointHazard(riskPointHazard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}/{hazardId}"})
    public JsonResult deleteRiskPointHazardById(@PathVariable Long riskPointId, @PathVariable Long hazardId) throws CustomException {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        try {
            this.riskPointHazardService.deleteRiskPointHazardById(ocId, riskPointId, checklistId, hazardId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/select"})
    public JsonResult getSelectHazardByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<ChecklistHazardDto> data = this.riskPointHazardService.getSelectHazardByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/view"})
    public JsonResult getRiskPointHazardViewByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<ChecklistHazardVo> data = this.riskPointHazardService.getRiskPointHazardViewByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }
}

