/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.EntRiskPointMapLayerDto;
import com.zhyc.xps.aqpt.service.EntRiskPointMapLayerService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/riskPoint/mapLayer"})
public class EntRiskPointMapLayerController
extends BaseController {
    @Resource
    EntRiskPointMapLayerService riskPointMapService;

    @GetMapping(value={"/{riskPointId}"})
    public JsonResult getRiskPointMapLayerByRiskPointId(@PathVariable Long riskPointId) {
        Long ocId = this.getCurOcId();
        EntRiskPointMapLayerDto riskPointMap = this.riskPointMapService.getRiskPointMapLayerById(ocId, riskPointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)riskPointMap);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRiskPointMapLayer(@RequestBody EntRiskPointMapLayerDto riskPointMapLayerDto) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            riskPointMapLayerDto.setOcId(ocId);
            this.riskPointMapService.createRiskPointMapLayer(riskPointMapLayerDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public JsonResult updateRiskPointMapLayer(@RequestBody EntRiskPointMapLayerDto riskPointMapLayerDto) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            riskPointMapLayerDto.setOcId(ocId);
            this.riskPointMapService.updateRiskPointMapLayer(riskPointMapLayerDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}/{mapId}/{layerId}"})
    public JsonResult deleteRiskPointMapLayerById(@PathVariable Long riskPointId, @PathVariable Long mapId, @PathVariable Long layerId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.riskPointMapService.deleteRiskPointMapLayerById(ocId, riskPointId, mapId, layerId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

