/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.job;

import com.zhyc.xps.aqpt.constant.Glob;
import com.zhyc.xps.aqpt.dto.CheckDefDto;
import com.zhyc.xps.aqpt.entity.CheckDef;
import com.zhyc.xps.aqpt.entity.CheckTask;
import com.zhyc.xps.aqpt.mapper.CheckDefMapper;
import com.zhyc.xps.aqpt.mapper.CheckTaskMapper;
import com.zhyc.xps.common.publisher.MsgPublisher;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.DateUtils;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.utils.MsgUtil;
import com.zhyc.xps.common.utils.jpush.JPushUtil;
import com.zhyc.xps.common.vo.MsgVo;
import com.zhyc.xps.sys.entity.Task;
import com.zhyc.xps.sys.mapper.TaskMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CheckTaskJobService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(CheckTaskJobService.class);
    @Resource
    CheckDefMapper checkDefMapper;
    @Resource
    TaskMapper taskMapper;
    @Resource
    CheckTaskMapper checkTaskMapper;
    @Resource
    MsgUtil msgUtil;
    @Resource
    MsgPublisher msgPublisher;
    @Resource
    JPushUtil jPushUtil;

    @Transactional
    public void execute(JobExecutionContext context) throws Exception {
        JobDataMap dataMap = context.getTrigger().getJobDataMap();
        long jobId = dataMap.getLongValue("jobId");
        Date nextFireTime = context.getNextFireTime();
        LocalDateTime tNow = LocalDateTime.now();
        String launchPositionName = "\u7ba1\u7406\u5458";
        String launchAccountName = "\u7ba1\u7406\u5458";
        LocalDateTime expectedStartTime = tNow;
        LocalDateTime expectedEndTime = DateUtils.asLocalDateTime((Date)nextFireTime);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", jobId);
        List<CheckDefDto> dataList = this.checkDefMapper.getPendingByList(map);
        for (CheckDefDto data : dataList) {
            Long ocId;
            Long userId = ocId = data.getOcId();
            Long launchGroupId = ocId;
            Long launchPositionId = ocId;
            Long launchAccountId = ocId;
            String launchGroupName = data.getOcName();
            Long handleGroupId = data.getGroupId();
            Long handlePositionId = data.getPositionId();
            Long handleAccountId = data.getAccountId();
            String handleGroupName = data.getGroupName();
            String handlePositionName = data.getPositionName();
            String handleAccountName = data.getAccountName();
            log.info(data.toString());
            Long checkCatId = data.getCheckCatId();
            String checkTitle = data.getCheckTitle();
            String checkDesc = data.getCheckDesc();
            Long riskPointId = data.getRiskPointId();
            Long checklistId = data.getChecklistId();
            Long taskId = IdKit.getId();
            String taskCode = IdKit.getTicksId();
            Task task = new Task();
            task.setOcId(ocId);
            task.setTaskId(taskId);
            task.setTaskCatId(Glob.TASK_CAT_1);
            task.setTaskPriority(Glob.TASK_PRIORITY_2);
            task.setTaskCode(taskCode);
            task.setTaskTitle(checkTitle);
            task.setTaskDesc(checkDesc);
            task.setTaskTypeId(Glob.TASK_TYPE_CHECK);
            task.setStatus(Long.valueOf(0L));
            task.setLaunchGroupId(ocId);
            task.setLaunchPositionId(ocId);
            task.setLaunchAccountId(ocId);
            task.setLaunchGroupName(launchGroupName);
            task.setLaunchPositionName(launchPositionName);
            task.setLaunchAccountName(launchAccountName);
            task.setExpectedStartTime(expectedStartTime);
            task.setExpectedEndTime(expectedEndTime);
            task.setHandleGroupId(handleGroupId);
            task.setHandleGroupName(handleGroupName);
            task.setHandlePositionId(handlePositionId);
            task.setHandlePositionName(handlePositionName);
            task.setHandleAccountId(handleAccountId);
            task.setHandleAccountName(handleAccountName);
            task.setCreatedAt(tNow);
            task.setCreatedBy(userId);
            this.taskMapper.create(task);
            CheckTask checkTask = new CheckTask();
            checkTask.setOcId(ocId);
            checkTask.setTaskId(taskId);
            checkTask.setCheckCatId(checkCatId);
            checkTask.setCheckTypeId(Glob.CHECK_TYPE_ROUTINE);
            checkTask.setCheckDefId(0L);
            checkTask.setCheckTitle(checkTitle);
            checkTask.setCheckDesc(checkDesc);
            checkTask.setRiskPointId(riskPointId);
            checkTask.setChecklistId(checklistId);
            checkTask.setCheckCount(1L);
            checkTask.setCheckStatus(0L);
            checkTask.setCreatedAt(tNow);
            checkTask.setCreatedBy(userId);
            this.checkTaskMapper.create(checkTask);
            CheckDef checkDef = new CheckDef();
            checkDef.setOcId(ocId);
            checkDef.setCheckDefId(data.getCheckDefId());
            checkDef.setRiskPointId(data.getRiskPointId());
            checkDef.setLastCycleStartTime(expectedStartTime);
            checkDef.setLastCycleEndTime(expectedEndTime);
            checkDef.setUpdatedAt(LocalDateTime.now());
            checkDef.setUpdatedBy(ocId);
            this.checkDefMapper.update(checkDef);
            MsgVo msg = new MsgVo();
            msg.setOcId(ocId);
            msg.setMsgCatId(Glob.MSG_CAT_SMS);
            msg.setMsgContent(checkTitle);
            msg.setMsgDetail(checkDesc);
            msg.setMsgFrId(ocId);
            msg.setMsgToId(handleAccountId);
            msg.setMsgToName(handleAccountName);
            this.msgPublisher.publishMsg(msg);
            this.jPushUtil.pushToUser(handleAccountId, "\u4efb\u52a1\u63d0\u9192", checkTitle, checkDesc, "intent:#Intent;action=android.intent.action.MAIN;end");
        }
    }
}

