/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.CheckCatDto;
import com.zhyc.xps.aqpt.entity.CheckCat;
import com.zhyc.xps.aqpt.mapper.CheckCatMapper;
import com.zhyc.xps.aqpt.service.CheckCatService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CheckCatServiceImpl
extends BaseService
implements CheckCatService {
    @Resource
    CheckCatMapper checkCatMapper;

    @Override
    public PageBean<CheckCatDto> getCheckCatByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<CheckCatDto> list = this.checkCatMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<CheckCatDto> getCheckCatByList(Map<String, Object> map) {
        return this.checkCatMapper.getByList(map);
    }

    @Override
    public CheckCatDto getCheckCatById(Long ocId, Long checkCatId) {
        return this.checkCatMapper.getById(ocId, checkCatId);
    }

    @Override
    public void createCheckCat(CheckCat cat) throws Exception {
        Long checkCatId = IdKit.getId();
        cat.setCheckCatId(checkCatId);
        cat.setCreatedAt(LocalDateTime.now());
        this.checkCatMapper.create(cat);
    }

    @Override
    public void updateCheckCat(CheckCat cat) throws Exception {
        cat.setUpdatedAt(LocalDateTime.now());
        this.checkCatMapper.update(cat);
    }

    @Override
    public void deleteCheckCat(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.checkCatMapper.delete(map);
    }
}

