/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.zhyc.xps.aqpt.dto.CheckRecordAttachDto;
import com.zhyc.xps.aqpt.dto.CheckTaskDoingItemDto;
import com.zhyc.xps.aqpt.entity.CheckRecordAttach;
import com.zhyc.xps.aqpt.entity.CheckTaskDoingItem;
import com.zhyc.xps.aqpt.mapper.CheckRecordAttachMapper;
import com.zhyc.xps.aqpt.mapper.CheckTaskDoingMapper;
import com.zhyc.xps.aqpt.service.CheckTaskDoingService;
import com.zhyc.xps.aqpt.vo.CheckTaskDoingItemVo;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.sys.mapper.DocFileMapper;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CheckTaskDoingServiceImpl
extends BaseService
implements CheckTaskDoingService {
    @Autowired
    CheckTaskDoingMapper checkTaskDoingMapper;
    @Autowired
    DocFileMapper docFileMapper;
    @Autowired
    CheckRecordAttachMapper attachMapper;

    @Override
    public CheckTaskDoingItemVo getCheckTaskDoingItemById(Long ocId, Long taskId, Long checkRecordId) {
        CheckTaskDoingItemDto item = this.checkTaskDoingMapper.getItemById(ocId, taskId, checkRecordId);
        if (item == null) {
            return null;
        }
        CheckTaskDoingItemVo itemVo = new CheckTaskDoingItemVo();
        itemVo.setOcId(item.getOcId());
        itemVo.setTaskId(item.getTaskId());
        itemVo.setAccountId(item.getAccountId());
        itemVo.setCheckRecordId(item.getCheckRecordId());
        itemVo.setCheckResult(item.getCheckResult());
        itemVo.setCheckDesc(item.getCheckDesc());
        itemVo.setDangerId(item.getDangerId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("taskId", taskId);
        map.put("checkRecordId", checkRecordId);
        List<CheckRecordAttachDto> attachList = this.attachMapper.getByList(map);
        itemVo.setAttachList(attachList);
        return itemVo;
    }

    @Override
    public void updateCheckTaskDoingItem(CheckTaskDoingItemVo itemVo) throws Exception {
        Long ocId = itemVo.getOcId();
        Long userId = itemVo.getAccountId();
        Long taskId = itemVo.getTaskId();
        Long checkRecordId = itemVo.getCheckRecordId();
        CheckTaskDoingItem item = new CheckTaskDoingItem();
        item.setOcId(ocId);
        item.setCheckRecordId(checkRecordId);
        item.setDangerId(itemVo.getDangerId());
        item.setTaskId(taskId);
        item.setAccountId(userId);
        item.setCheckResult(itemVo.getCheckResult());
        item.setCheckDesc(itemVo.getCheckDesc());
        item.setUpdatedAt(LocalDateTime.now());
        item.setUpdatedBy(itemVo.getUpdatedBy());
        this.checkTaskDoingMapper.updateItem(item);
        List<CheckRecordAttachDto> attachList = itemVo.getAttachList();
        if (attachList == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("taskId", taskId);
        map.put("checkRecordId", checkRecordId);
        this.attachMapper.delete(map);
        for (CheckRecordAttachDto attachDto : attachList) {
            Long fileId = attachDto.getFileId();
            CheckRecordAttach attach = new CheckRecordAttach();
            attach.setOcId(ocId);
            attach.setTaskId(taskId);
            attach.setCheckRecordId(checkRecordId);
            attach.setFileId(fileId);
            attach.setCreatedBy(userId);
            attach.setCreatedAt(LocalDateTime.now());
            this.attachMapper.create(attach);
        }
    }

    @Override
    public Boolean verifyCheckTaskDoingIsComplete(Map<String, Object> map) {
        map.put("checkResult", 0);
        List<CheckTaskDoingItemDto> checkTaskDoingItemDtoList = this.checkTaskDoingMapper.getItemByList(map);
        if (checkTaskDoingItemDtoList != null && checkTaskDoingItemDtoList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public void batchUpdateCheckTaskDoingItem(Long ocId, Long taskId, Long checkResult) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("taskId", taskId);
        map.put("checkResult", checkResult);
        this.checkTaskDoingMapper.batchUpdateItem(map);
    }

    @Override
    public void deleteCheckTaskDoingItemById(Long ocId, Long taskId, Long checkRecordId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("taskId", taskId);
        map.put("checkRecordId", checkRecordId);
        this.checkTaskDoingMapper.deleteItem(map);
    }
}

