/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.constant.Glob;
import com.zhyc.xps.aqpt.dto.AlertDto;
import com.zhyc.xps.aqpt.dto.CheckRecordDto;
import com.zhyc.xps.aqpt.dto.CheckTaskDetailDto;
import com.zhyc.xps.aqpt.dto.CheckTaskDoingItemDto;
import com.zhyc.xps.aqpt.dto.CheckTaskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointDto;
import com.zhyc.xps.aqpt.entity.Alert;
import com.zhyc.xps.aqpt.entity.CheckRecord;
import com.zhyc.xps.aqpt.entity.CheckTask;
import com.zhyc.xps.aqpt.entity.CheckTaskDoingItem;
import com.zhyc.xps.aqpt.entity.EntRiskPoint;
import com.zhyc.xps.aqpt.mapper.AlertMapper;
import com.zhyc.xps.aqpt.mapper.CheckDefMapper;
import com.zhyc.xps.aqpt.mapper.CheckRecordMapper;
import com.zhyc.xps.aqpt.mapper.CheckTaskDoingMapper;
import com.zhyc.xps.aqpt.mapper.CheckTaskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.service.AlertService;
import com.zhyc.xps.aqpt.service.CheckTaskService;
import com.zhyc.xps.aqpt.service.EntRiskPointService;
import com.zhyc.xps.aqpt.vo.CheckTaskHazardRiskMeasureVo;
import com.zhyc.xps.aqpt.vo.CheckTaskHazardRiskVo;
import com.zhyc.xps.aqpt.vo.CheckTaskHazardVo;
import com.zhyc.xps.aqpt.vo.CheckTaskVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.service.QywxService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.utils.IdGenerator.sequence.AqptSequenceContext;
import com.zhyc.xps.common.utils.StringUtils;
import com.zhyc.xps.common.utils.ws.WsClientKit;
import com.zhyc.xps.common.vo.TaskUserVo;
import com.zhyc.xps.sys.dto.AccountDto;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.entity.Task;
import com.zhyc.xps.sys.mapper.AccountMapper;
import com.zhyc.xps.sys.mapper.GroupMapper;
import com.zhyc.xps.sys.mapper.TaskMapper;
import com.zhyc.xps.sys.service.MsgService;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class CheckTaskServiceImpl
extends BaseService
implements CheckTaskService {
    private static final Logger log = LoggerFactory.getLogger(CheckTaskServiceImpl.class);
    @Resource
    TaskMapper taskMapper;
    @Resource
    GroupMapper groupMapper;
    @Resource
    CheckDefMapper checkDefMapper;
    @Resource
    CheckTaskMapper checkTaskMapper;
    @Resource
    ChecklistHazardMapper hazardMapper;
    @Resource
    ChecklistHazardRiskMapper riskMapper;
    @Resource
    ChecklistHazardRiskMeasureMapper measureMapper;
    @Resource
    CheckTaskDoingMapper checkTaskDoingMapper;
    @Resource
    CheckRecordMapper checkRecordMapper;
    @Resource
    EntRiskPointService riskPointService;
    @Resource
    AlertService alertService;
    @Resource
    QywxService QywxService;
    @Resource
    AlertMapper alertMapper;
    @Resource
    AccountMapper accountMapper;
    @Resource
    MsgService msgService;
    @Resource
    ThreadPoolExecutor executor;
    @Resource
    AqptSequenceContext aqptSequenceContext;

    @Override
    public CheckTaskDto getCheckTaskById(Long ocId, Long taskId) {
        return this.checkTaskMapper.getById(ocId, taskId);
    }

    @Override
    public PageBean<CheckTaskDto> getCheckTaskByPage(Map<String, Object> map) {
        Long groupId;
        Long ocId;
        GroupDto group;
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        if (map.containsKey("handleGroupId") && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), groupId = Long.valueOf("0" + map.get("handleGroupId")))))) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.remove("handleGroupId");
        }
        PageHelper.startPage((int)page, (int)limit);
        List<CheckTaskDto> list = this.checkTaskMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<CheckTaskDto> getCheckTaskByList(Map<String, Object> map) {
        Long groupId;
        Long ocId;
        GroupDto group;
        if (map.containsKey("handleGroupId") && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), groupId = Long.valueOf("0" + map.get("handleGroupId")))))) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.remove("handleGroupId");
        }
        return this.checkTaskMapper.getByList(map);
    }

    @Override
    public void createOnceCheckTask(CheckTaskDto checkTaskDto, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long taskId = IdKit.getId();
        Long taskCatId = checkTaskDto.getTaskCatId();
        String taskTitle = checkTaskDto.getTaskTitle();
        String taskDesc = checkTaskDto.getTaskDesc();
        String taskCode = IdKit.getTicksId();
        LocalDateTime expectedStartTime = checkTaskDto.getExpectedStartTime();
        LocalDateTime expectedEndTime = checkTaskDto.getExpectedEndTime();
        Task task = new Task();
        task.setOcId(ocId);
        task.setTaskId(taskId);
        task.setTaskCatId(taskCatId);
        task.setTaskPriority(checkTaskDto.getTaskPriority());
        task.setTaskCode(taskCode);
        task.setTaskTitle(taskTitle);
        task.setTaskDesc(taskDesc);
        task.setTaskTypeId(Glob.TASK_TYPE_GENERAL);
        task.setLaunchGroupId(groupId);
        task.setLaunchPositionId(positionId);
        task.setLaunchAccountId(userId);
        task.setExpectedStartTime(expectedStartTime);
        task.setExpectedEndTime(expectedEndTime);
        task.setHandleGroupId(checkTaskDto.getHandleGroupId());
        task.setHandlePositionId(checkTaskDto.getHandlePositionId());
        task.setHandleAccountId(checkTaskDto.getHandleAccountId());
        task.setHandleGroupName(checkTaskDto.getHandleGroupName());
        task.setHandlePositionName(checkTaskDto.getHandlePositionName());
        task.setHandleAccountName(checkTaskDto.getHandleAccountName());
        task.setCreatedAt(LocalDateTime.now());
        task.setCreatedBy(userId);
        this.taskMapper.create(task);
        CheckTask checkTask = new CheckTask();
        checkTask.setOcId(ocId);
        checkTask.setTaskId(taskId);
        checkTask.setCheckDefId(0L);
        checkTask.setCheckTitle(taskTitle);
        checkTask.setCheckDesc(taskDesc);
        checkTask.setRiskPointId(checkTaskDto.getRiskPointId());
        checkTask.setChecklistId(checkTaskDto.getChecklistId());
        checkTask.setCheckCount(1L);
        checkTask.setCreatedAt(LocalDateTime.now());
        checkTask.setCreatedBy(userId);
        this.checkTaskMapper.create(checkTask);
    }

    @Override
    public CheckTaskVo createQuickCheckTask(CheckTaskDto checkTaskDto, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String userName = user.getAccountName();
        Long taskId = IdKit.getId();
        Long taskCatId = checkTaskDto.getTaskCatId();
        String taskTitle = checkTaskDto.getTaskTitle();
        String taskDesc = checkTaskDto.getTaskDesc();
        String taskCode = IdKit.getTicksId();
        LocalDateTime expectedStartTime = LocalDateTime.now();
        LocalDateTime expectedEndTime = expectedStartTime.plusDays(7L);
        Long riskPointId = checkTaskDto.getRiskPointId();
        Long checklistId = checkTaskDto.getChecklistId();
        Long checklistTypeId = checkTaskDto.getChecklistTypeId();
        CompletableFuture<Void> taskFuture = CompletableFuture.runAsync(() -> {
            try {
                Task task = new Task();
                task.setOcId(ocId);
                task.setTaskId(taskId);
                task.setTaskCatId(taskCatId);
                task.setTaskPriority(Glob.TASK_PRIORITY_2);
                task.setTaskCode(taskCode);
                task.setTaskTitle(taskTitle);
                task.setTaskDesc(taskDesc);
                task.setLaunchGroupId(groupId);
                task.setLaunchPositionId(positionId);
                task.setLaunchAccountId(userId);
                task.setTaskTypeId(Glob.TASK_TYPE_GENERAL);
                task.setExpectedStartTime(expectedStartTime);
                task.setExpectedEndTime(expectedEndTime);
                task.setHandleGroupId(groupId);
                task.setHandlePositionId(positionId);
                task.setHandleAccountId(userId);
                task.setHandleGroupName(groupName);
                task.setHandlePositionName(positionName);
                task.setHandleAccountName(userName);
                task.setCreatedAt(LocalDateTime.now());
                task.setCreatedBy(userId);
                this.taskMapper.create(task);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, this.executor);
        CompletableFuture<Void> checkTaskFuture = CompletableFuture.runAsync(() -> {
            try {
                CheckTask checkTask = new CheckTask();
                checkTask.setOcId(ocId);
                checkTask.setTaskId(taskId);
                checkTask.setCheckDefId(0L);
                checkTask.setCheckTitle(taskTitle);
                checkTask.setCheckDesc(taskDesc);
                checkTask.setRiskPointId(riskPointId);
                checkTask.setChecklistId(checklistId);
                checkTask.setCheckCount(1L);
                checkTask.setCreatedAt(LocalDateTime.now());
                checkTask.setCreatedBy(userId);
                this.checkTaskMapper.create(checkTask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, this.executor);
        CompletableFuture<Void> taskItemFuture = CompletableFuture.runAsync(() -> {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("ocId", ocId);
            if (checklistTypeId == 1L) {
                map1.put("riskPointId", riskPointId);
                map1.put("checklistId", ocId);
                map1.put("ctrlLevelId", checklistId);
            } else {
                map1.put("checklistId", checklistId);
            }
            ArrayList<CheckTaskDoingItem> checkTaskDoingItemList = new ArrayList<CheckTaskDoingItem>();
            List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map1);
            for (ChecklistHazardRiskMeasureDto item : measureList) {
                Long checkRecordId = null;
                try {
                    checkRecordId = this.aqptSequenceContext.nextId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CheckTaskDoingItem taskItem = new CheckTaskDoingItem();
                taskItem.setOcId(ocId);
                taskItem.setGroupId(groupId);
                taskItem.setPositionId(positionId);
                taskItem.setAccountId(userId);
                taskItem.setTaskId(taskId);
                taskItem.setCheckRecordId(checkRecordId);
                taskItem.setRiskPointId(riskPointId);
                taskItem.setChecklistId(checklistId);
                taskItem.setAccountId(userId);
                taskItem.setHazardId(item.getHazardId());
                taskItem.setRiskId(item.getRiskId());
                taskItem.setMeasureId(item.getMeasureId());
                taskItem.setCreatedAt(LocalDateTime.now());
                taskItem.setCheckResult(Glob.CHECK_RESULT_0);
                taskItem.setCreatedBy(userId);
                checkTaskDoingItemList.add(taskItem);
            }
            if (!ObjectUtils.isEmpty(checkTaskDoingItemList)) {
                try {
                    this.checkTaskDoingMapper.createItemBatch(checkTaskDoingItemList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, this.executor);
        CompletableFuture.allOf(taskFuture, checkTaskFuture, taskItemFuture).get();
        CheckTaskDto targetTask = this.checkTaskMapper.getById(ocId, taskId);
        if (targetTask == null) {
            return null;
        }
        CheckTaskVo checkTaskVo = new CheckTaskVo();
        checkTaskVo.setTaskId(taskId);
        return checkTaskVo;
    }

    @Override
    public void updateCheckTask(CheckTaskDto checkTaskDto, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long taskId = checkTaskDto.getTaskId();
        Long taskCatId = checkTaskDto.getTaskCatId();
        String taskTitle = checkTaskDto.getTaskTitle();
        String taskDesc = checkTaskDto.getTaskDesc();
        LocalDateTime expectedStartTime = checkTaskDto.getExpectedStartTime();
        LocalDateTime expectedEndTime = checkTaskDto.getExpectedEndTime();
        Task task = new Task();
        task.setOcId(ocId);
        task.setTaskId(taskId);
        task.setTaskTitle(taskTitle);
        task.setTaskDesc(taskDesc);
        task.setTaskCatId(taskCatId);
        task.setTaskPriority(checkTaskDto.getTaskPriority());
        task.setExpectedStartTime(expectedStartTime);
        task.setExpectedEndTime(expectedEndTime);
        task.setHandleGroupId(checkTaskDto.getHandleGroupId());
        task.setHandlePositionId(checkTaskDto.getHandlePositionId());
        task.setHandleAccountId(checkTaskDto.getHandleAccountId());
        task.setHandleGroupName(checkTaskDto.getHandleGroupName());
        task.setHandlePositionName(checkTaskDto.getHandlePositionName());
        task.setHandleAccountName(checkTaskDto.getHandleAccountName());
        task.setUpdatedAt(LocalDateTime.now());
        task.setUpdatedBy(userId);
        this.taskMapper.update(task);
        CheckTask checkTask = new CheckTask();
        checkTask.setOcId(ocId);
        checkTask.setTaskId(taskId);
        checkTask.setCheckTitle(taskTitle);
        checkTask.setCheckDesc(taskDesc);
        checkTask.setRiskPointId(checkTaskDto.getRiskPointId());
        checkTask.setChecklistId(checkTaskDto.getChecklistId());
        checkTask.setCheckCount(checkTaskDto.getCheckCount());
        checkTask.setUpdatedAt(LocalDateTime.now());
        checkTask.setUpdatedBy(userId);
        this.checkTaskMapper.update(checkTask);
    }

    @Override
    public void deleteCheckTaskById(Long taskId, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        map.put("ocId", ocId);
        map.put("taskId", taskId);
        this.taskMapper.delete(map);
        this.checkTaskMapper.delete(map);
    }

    @Override
    public CheckTaskVo handleTask(Long taskId, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        CheckTaskDto checkTask = this.checkTaskMapper.getById(ocId, taskId);
        if (ObjectUtils.isEmpty((Object)checkTask)) {
            return null;
        }
        Long checkStatus = checkTask.getCheckStatus();
        Long checklistTypeId = checkTask.getChecklistTypeId();
        Long riskPointId = checkTask.getRiskPointId();
        Long checklistId = checkTask.getChecklistId();
        if (checkStatus.equals(0L)) {
            Task task = new Task();
            task.setOcId(ocId);
            task.setActualStartTime(LocalDateTime.now());
            task.setUpdatedAt(LocalDateTime.now());
            task.setUpdatedBy(userId);
            this.taskMapper.update(task);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("ocId", ocId);
            if (checklistTypeId == 1L) {
                map1.put("riskPointId", riskPointId);
                map1.put("checklistId", ocId);
                map1.put("ctrlLevelId", checklistId);
            } else {
                map1.put("checklistId", checklistId);
            }
            List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map1);
            for (ChecklistHazardRiskMeasureDto item : measureList) {
                Long checkRecordId = IdKit.getId();
                CheckTaskDoingItem taskItem = new CheckTaskDoingItem();
                taskItem.setOcId(ocId);
                taskItem.setGroupId(groupId);
                taskItem.setPositionId(positionId);
                taskItem.setAccountId(userId);
                taskItem.setTaskId(taskId);
                taskItem.setCheckRecordId(checkRecordId);
                taskItem.setRiskPointId(riskPointId);
                taskItem.setChecklistId(checkTask.getChecklistId());
                taskItem.setAccountId(checkTask.getHandleAccountId());
                taskItem.setHazardId(item.getHazardId());
                taskItem.setRiskId(item.getRiskId());
                taskItem.setMeasureId(item.getMeasureId());
                taskItem.setCreatedAt(LocalDateTime.now());
                taskItem.setCheckResult(Glob.CHECK_RESULT_0);
                taskItem.setCreatedBy(userId);
                this.checkTaskDoingMapper.createItem(taskItem);
            }
            CheckTask checkTaskNow = new CheckTask();
            checkTaskNow.setOcId(ocId);
            checkTaskNow.setTaskId(taskId);
            checkTaskNow.setCheckStatus(1L);
            checkTaskNow.setUpdatedAt(LocalDateTime.now());
            checkTaskNow.setUpdatedBy(userId);
            this.checkTaskMapper.update(checkTaskNow);
        }
        CheckTaskVo checkTaskVo = new CheckTaskVo();
        checkTaskVo.setTaskId(taskId);
        checkTaskVo.setTaskTitle(checkTask.getTaskTitle());
        checkTaskVo.setTaskCatId(checkTask.getTaskCatId());
        checkTaskVo.setTaskCatTitle(checkTask.getTaskCatTitle());
        checkTaskVo.setTaskPriority(checkTask.getTaskPriority());
        checkTaskVo.setTaskDesc(checkTask.getTaskDesc());
        checkTaskVo.setStatus(checkTask.getStatus());
        checkTaskVo.setExpectedStartTime(checkTask.getExpectedStartTime());
        checkTaskVo.setExpectedEndTime(checkTask.getExpectedEndTime());
        checkTaskVo.setActualStartTime(checkTask.getActualStartTime());
        checkTaskVo.setActualEndTime(checkTask.getActualEndTime());
        checkTaskVo.setLaunchGroupId(checkTask.getLaunchGroupId());
        checkTaskVo.setLaunchGroupName(checkTask.getLaunchGroupName());
        checkTaskVo.setLaunchPositionId(checkTask.getLaunchPositionId());
        checkTaskVo.setLaunchPositionName(checkTask.getLaunchPositionName());
        checkTaskVo.setLaunchAccountId(checkTask.getLaunchAccountId());
        checkTaskVo.setLaunchAccountName(checkTask.getLaunchAccountName());
        checkTaskVo.setHandleGroupId(checkTask.getHandleGroupId());
        checkTaskVo.setHandleGroupName(checkTask.getHandleGroupName());
        checkTaskVo.setHandlePositionId(checkTask.getHandlePositionId());
        checkTaskVo.setHandlePositionName(checkTask.getHandlePositionName());
        checkTaskVo.setHandleAccountId(checkTask.getHandleAccountId());
        checkTaskVo.setHandleAccountName(checkTask.getHandleAccountName());
        checkTaskVo.setRiskPointId(riskPointId);
        checkTaskVo.setRiskPointTitle(checkTask.getRiskPointTitle());
        checkTaskVo.setCheckCatId(checkTask.getCheckCatId());
        checkTaskVo.setCheckCatTitle(checkTask.getCheckCatTitle());
        checkTaskVo.setCheckTypeId(checkTask.getCheckTypeId());
        checkTaskVo.setCheckStatus(checkStatus);
        checkTaskVo.setChecklistId(checklistId);
        checkTaskVo.setChecklistTitle(checkTask.getChecklistTitle());
        checkTaskVo.setChecklistTypeId(checklistTypeId);
        checkTaskVo.setChecklistCatId(checkTask.getChecklistCatId());
        checkTaskVo.setChecklistCatTitle(checkTask.getChecklistCatTitle());
        checkTaskVo.setChecklistDesc(checkTask.getChecklistDesc());
        checkTaskVo.setChecklistVersion(checkTask.getChecklistVersion());
        List<CheckTaskHazardVo> hazardVoList = this.getHandlingCheckTaskData(checkTask);
        checkTaskVo.setHazardList(hazardVoList);
        checkTaskVo.setHazardCount(hazardVoList.size());
        return checkTaskVo;
    }

    @Override
    public void completeTask(Long taskId, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long accountId = user.getAccountId();
        CheckTaskDto checkTask = this.checkTaskMapper.getById(ocId, taskId);
        if (checkTask == null) {
            throw new Exception("Task\u4e0d\u5b58\u5728");
        }
        Task task = new Task();
        task.setOcId(ocId);
        task.setTaskId(taskId);
        task.setActualEndTime(LocalDateTime.now());
        task.setStatus(Long.valueOf(1L));
        this.taskMapper.update(task);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("taskId", taskId);
        List<CheckTaskDoingItemDto> itemList = this.checkTaskDoingMapper.getItemByList(map1);
        for (CheckTaskDoingItemDto item : itemList) {
            CheckRecord record = new CheckRecord();
            record.setOcId(ocId);
            record.setTaskId(taskId);
            record.setCheckRecordId(item.getCheckRecordId());
            record.setGroupId(item.getGroupId());
            record.setPositionId(item.getPositionId());
            record.setAccountId(item.getAccountId());
            record.setRiskPointId(item.getRiskPointId());
            record.setChecklistId(item.getChecklistId());
            record.setHazardId(item.getHazardId());
            record.setHazardTitle(item.getHazardTitle());
            record.setHazardCode(item.getHazardCode());
            record.setRiskId(item.getRiskId());
            record.setRiskTitle(item.getRiskTitle());
            record.setRiskCode(item.getRiskCode());
            record.setMeasureId(item.getMeasureId());
            record.setMeasureContent(item.getMeasureContent());
            record.setMeasureTypeId(item.getMeasureTypeId());
            record.setMeasureReference(item.getMeasureReference());
            record.setCheckResult(item.getCheckResult());
            record.setCheckTime(item.getCheckTime());
            record.setCheckDesc(item.getCheckDesc());
            record.setCreatedAt(item.getCreatedAt());
            record.setCreatedBy(item.getCreatedBy());
            this.checkRecordMapper.create(record);
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("ocId", ocId);
        map2.put("taskId", taskId);
        this.checkTaskDoingMapper.deleteItem(map2);
        CheckTask ckTask = new CheckTask();
        ckTask.setOcId(ocId);
        ckTask.setTaskId(taskId);
        ckTask.setCheckStatus(2L);
        this.checkTaskMapper.update(ckTask);
    }

    @Override
    public void transferTask(Long taskId, TaskUserVo userFr, TaskUserVo userTo) throws Exception {
        Long ocId = userFr.getOcId();
        Long userId = userFr.getAccountId();
        CheckTaskDto checkTask = this.checkTaskMapper.getById(ocId, taskId);
        if (checkTask == null) {
            throw new Exception("Task\u4e0d\u5b58\u5728");
        }
        Task task = new Task();
        task.setOcId(ocId);
        task.setTaskId(taskId);
        task.setHandleGroupId(userTo.getGroupId());
        task.setHandlePositionId(userTo.getPositionId());
        task.setHandleAccountId(userTo.getAccountId());
        task.setUpdatedBy(userId);
        task.setUpdatedAt(LocalDateTime.now());
        this.taskMapper.update(task);
    }

    @Override
    public void cancelTask(Long taskId, TaskUserVo user) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        CheckTaskDto checkTask = this.checkTaskMapper.getById(ocId, taskId);
        if (checkTask == null) {
            throw new Exception("Task\u4e0d\u5b58\u5728");
        }
        Task task = new Task();
        task.setOcId(ocId);
        task.setTaskId(taskId);
        task.setActualEndTime(LocalDateTime.now());
        this.taskMapper.update(task);
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("taskId", taskId);
        List<CheckTaskDoingItemDto> itemList = this.checkTaskDoingMapper.getItemByList(map1);
        for (CheckTaskDoingItemDto item : itemList) {
            CheckRecord record = new CheckRecord();
            record.setOcId(ocId);
            record.setCheckRecordId(item.getCheckRecordId());
            record.setTaskId(taskId);
            record.setGroupId(item.getGroupId());
            record.setPositionId(item.getPositionId());
            record.setAccountId(item.getAccountId());
            record.setRiskPointId(item.getRiskPointId());
            record.setChecklistId(item.getChecklistId());
            record.setHazardId(item.getHazardId());
            record.setHazardTitle(item.getHazardTitle());
            record.setHazardCode(item.getHazardCode());
            record.setRiskId(item.getRiskId());
            record.setRiskTitle(item.getRiskTitle());
            record.setRiskCode(item.getRiskCode());
            record.setMeasureId(item.getMeasureId());
            record.setMeasureTypeId(item.getMeasureTypeId());
            record.setMeasureContent(item.getMeasureContent());
            record.setMeasureReference(item.getMeasureReference());
            record.setCheckResult(item.getCheckResult());
            record.setCheckTime(item.getCheckTime());
            record.setCheckDesc(item.getCheckDesc());
            record.setCreatedAt(item.getCreatedAt());
            record.setCreatedBy(item.getCreatedBy());
            this.checkRecordMapper.create(record);
        }
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("ocId", ocId);
        map2.put("taskId", taskId);
        this.checkTaskDoingMapper.deleteItem(map2);
    }

    @Override
    public CheckTaskVo getCheckTaskViewById(Long ocId, Long taskId) {
        CheckTaskDto checkTask = this.checkTaskMapper.getById(ocId, taskId);
        if (ObjectUtils.isEmpty((Object)checkTask)) {
            return null;
        }
        Long checklistTypeId = checkTask.getChecklistTypeId();
        Long riskPointId = checkTask.getRiskPointId();
        Long checklistId = checkTask.getChecklistId();
        Long taskStatus = checkTask.getStatus();
        Long checkStatus = checkTask.getCheckStatus();
        CheckTaskVo checkTaskVo = new CheckTaskVo();
        checkTaskVo.setTaskId(taskId);
        checkTaskVo.setTaskTitle(checkTask.getTaskTitle());
        checkTaskVo.setTaskCatId(checkTask.getTaskCatId());
        checkTaskVo.setTaskCatTitle(checkTask.getTaskCatTitle());
        checkTaskVo.setTaskPriority(checkTask.getTaskPriority());
        checkTaskVo.setTaskDesc(checkTask.getTaskDesc());
        checkTaskVo.setStatus(checkTask.getStatus());
        checkTaskVo.setExpectedStartTime(checkTask.getExpectedStartTime());
        checkTaskVo.setExpectedEndTime(checkTask.getExpectedEndTime());
        checkTaskVo.setActualStartTime(checkTask.getActualStartTime());
        checkTaskVo.setActualEndTime(checkTask.getActualEndTime());
        checkTaskVo.setLaunchGroupId(checkTask.getLaunchGroupId());
        checkTaskVo.setLaunchGroupName(checkTask.getLaunchGroupName());
        checkTaskVo.setLaunchPositionId(checkTask.getLaunchPositionId());
        checkTaskVo.setLaunchPositionName(checkTask.getLaunchPositionName());
        checkTaskVo.setLaunchAccountId(checkTask.getLaunchAccountId());
        checkTaskVo.setLaunchAccountName(checkTask.getLaunchAccountName());
        checkTaskVo.setHandleGroupId(checkTask.getHandleGroupId());
        checkTaskVo.setHandleGroupName(checkTask.getHandleGroupName());
        checkTaskVo.setHandlePositionId(checkTask.getHandlePositionId());
        checkTaskVo.setHandlePositionName(checkTask.getHandlePositionName());
        checkTaskVo.setHandleAccountId(checkTask.getHandleAccountId());
        checkTaskVo.setHandleAccountName(checkTask.getHandleAccountName());
        checkTaskVo.setRiskPointId(riskPointId);
        checkTaskVo.setRiskPointTitle(checkTask.getRiskPointTitle());
        checkTaskVo.setCheckCatId(checkTask.getCheckCatId());
        checkTaskVo.setCheckCatTitle(checkTask.getCheckCatTitle());
        checkTaskVo.setCheckTypeId(checkTask.getCheckTypeId());
        checkTaskVo.setCheckStatus(checkStatus);
        checkTaskVo.setChecklistId(checklistId);
        checkTaskVo.setChecklistTitle(checkTask.getChecklistTitle());
        checkTaskVo.setChecklistTypeId(checklistTypeId);
        checkTaskVo.setChecklistCatId(checkTask.getChecklistCatId());
        checkTaskVo.setChecklistCatTitle(checkTask.getChecklistCatTitle());
        checkTaskVo.setChecklistDesc(checkTask.getChecklistDesc());
        checkTaskVo.setChecklistVersion(checkTask.getChecklistVersion());
        List<CheckTaskHazardVo> hazardVoList = checkStatus == 0L ? this.getWaitingCheckTaskData(checkTask) : (checkStatus == 1L ? this.getHandlingCheckTaskData(checkTask) : this.getHandledCheckTaskData(checkTask));
        checkTaskVo.setHazardList(hazardVoList);
        checkTaskVo.setHazardCount(hazardVoList.size());
        return checkTaskVo;
    }

    public List<CheckTaskHazardVo> getHandlingCheckTaskData(CheckTaskDto checkTask) {
        Long ocId = checkTask.getOcId();
        Long taskId = checkTask.getTaskId();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("waitingTaskId", taskId);
        List<ChecklistHazardDto> hazardList = this.hazardMapper.getByList(map1);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("ocId", ocId);
        map2.put("waitingTaskId", taskId);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("ocId", ocId);
        map3.put("taskId", taskId);
        List<CheckTaskDoingItemDto> measureList = this.checkTaskDoingMapper.getItemByList(map3);
        ArrayList<CheckTaskHazardVo> hazardVoList = new ArrayList<CheckTaskHazardVo>();
        for (ChecklistHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            CheckTaskHazardVo hazardVo = new CheckTaskHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<CheckTaskHazardRiskVo> riskVoList = new ArrayList<CheckTaskHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                CheckTaskHazardRiskVo riskVo = new CheckTaskHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<CheckTaskHazardRiskMeasureVo> measureVoList = new ArrayList<CheckTaskHazardRiskMeasureVo>();
                for (CheckTaskDoingItemDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    CheckTaskHazardRiskMeasureVo measureVo = new CheckTaskHazardRiskMeasureVo();
                    measureVo.setCheckRecordId(measure.getCheckRecordId());
                    measureVo.setMeasureId(measure.getMeasureId());
                    measureVo.setMeasureContent(measure.getMeasureContent());
                    measureVo.setMeasureTypeId(measure.getMeasureTypeId());
                    measureVo.setMeasureTypeTitle(measure.getMeasureTypeTitle());
                    measureVo.setMeasureReference(measure.getMeasureReference());
                    measureVo.setCheckTime(measure.getCheckTime());
                    measureVo.setCheckResult(measure.getCheckResult());
                    measureVo.setDangerId(measure.getDangerId());
                    measureVoList.add(measureVo);
                }
                riskVo.setMeasureList(measureVoList);
                riskVo.setMeasureCount(measureVoList.size());
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVo.setRiskCount(riskVoList.size());
            hazardVoList.add(hazardVo);
        }
        return hazardVoList;
    }

    public List<CheckTaskHazardVo> getWaitingCheckTaskData(CheckTaskDto checkTask) {
        Long ocId = checkTask.getOcId();
        Long riskPointId = checkTask.getRiskPointId();
        Long checklistId = checkTask.getChecklistId();
        Long checklistTypeId = checkTask.getChecklistTypeId();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        if (checklistTypeId == 1L) {
            map1.put("riskPointId", riskPointId);
            map1.put("checklistId", ocId);
            map1.put("ctrlLevelId", checklistId);
        } else {
            map1.put("checklistId", checklistId);
        }
        List<ChecklistHazardDto> hazardList = this.hazardMapper.getByList(map1);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map1);
        List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map1);
        ArrayList<CheckTaskHazardVo> hazardVoList = new ArrayList<CheckTaskHazardVo>();
        for (ChecklistHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            CheckTaskHazardVo hazardVo = new CheckTaskHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<CheckTaskHazardRiskVo> riskVoList = new ArrayList<CheckTaskHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                CheckTaskHazardRiskVo riskVo = new CheckTaskHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<CheckTaskHazardRiskMeasureVo> measureVoList = new ArrayList<CheckTaskHazardRiskMeasureVo>();
                for (ChecklistHazardRiskMeasureDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    CheckTaskHazardRiskMeasureVo measureVo = new CheckTaskHazardRiskMeasureVo();
                    measureVo.setMeasureId(measure.getMeasureId());
                    measureVo.setMeasureContent(measure.getMeasureContent());
                    measureVo.setMeasureTypeId(measure.getMeasureTypeId());
                    measureVo.setMeasureTypeTitle(measure.getMeasureTypeTitle());
                    measureVo.setMeasureReference(measure.getMeasureReference());
                    measureVoList.add(measureVo);
                }
                riskVo.setMeasureList(measureVoList);
                riskVo.setMeasureCount(measureVoList.size());
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVo.setRiskCount(riskVoList.size());
            hazardVoList.add(hazardVo);
        }
        return hazardVoList;
    }

    public List<CheckTaskHazardVo> getHandledCheckTaskData(CheckTaskDto checkTask) {
        Long ocId = checkTask.getOcId();
        Long taskId = checkTask.getTaskId();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("handledTaskId", taskId);
        List<ChecklistHazardDto> hazardList = this.hazardMapper.getByList(map1);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("ocId", ocId);
        map2.put("handledTaskId", taskId);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map2);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("ocId", ocId);
        map3.put("taskId", taskId);
        List<CheckRecordDto> measureList = this.checkRecordMapper.getByList(map3);
        ArrayList<CheckTaskHazardVo> hazardVoList = new ArrayList<CheckTaskHazardVo>();
        for (ChecklistHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            CheckTaskHazardVo hazardVo = new CheckTaskHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<CheckTaskHazardRiskVo> riskVoList = new ArrayList<CheckTaskHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                CheckTaskHazardRiskVo riskVo = new CheckTaskHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<CheckTaskHazardRiskMeasureVo> measureVoList = new ArrayList<CheckTaskHazardRiskMeasureVo>();
                for (CheckRecordDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    CheckTaskHazardRiskMeasureVo measureVo = new CheckTaskHazardRiskMeasureVo();
                    measureVo.setMeasureId(measure.getMeasureId());
                    measureVo.setMeasureContent(measure.getMeasureContent());
                    measureVo.setMeasureTypeId(measure.getMeasureTypeId());
                    measureVo.setMeasureTypeTitle(measure.getMeasureTypeTitle());
                    measureVo.setMeasureReference(measure.getMeasureReference());
                    measureVo.setCheckTime(measure.getCheckTime());
                    measureVo.setCheckResult(measure.getCheckResult());
                    measureVo.setDangerId(measure.getDangerId());
                    measureVoList.add(measureVo);
                }
                riskVo.setMeasureList(measureVoList);
                riskVo.setMeasureCount(measureVoList.size());
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVo.setRiskCount(riskVoList.size());
            hazardVoList.add(hazardVo);
        }
        return hazardVoList;
    }

    @Override
    public void handleExceedCheckTask() {
        List<CheckTaskDetailDto> taskList = this.checkTaskMapper.getCheckTaskExceedList();
        for (CheckTaskDetailDto task : taskList) {
            Long rpId;
            Long ocId = task.getOcId();
            AlertDto alertIns = this.alertMapper.getAlertByRiskPointId(ocId, rpId = task.getRiskPointId(), task.getTaskId());
            if (alertIns != null) continue;
            try {
                EntRiskPoint riskPoint = new EntRiskPoint();
                riskPoint.setRiskPointId(rpId);
                riskPoint.setOcId(ocId);
                riskPoint.setStatus(2L);
                this.riskPointService.updateRiskPoint(riskPoint);
                log.info("-----------\u98ce\u9669\u70b9\u903e\u671f\u72b6\u6001\u5904\u7406\u5b8c\u6210------\u9884\u8b66\u4fe1\u606f\u5904\u7406\u5f00\u59cb----{0}", (Object)riskPoint.getRiskPointId());
                Alert alert = new Alert();
                alert.setOcId(ocId);
                alert.setAlertLevel(6L);
                alert.setRiskPointId(rpId);
                alert.setAlertTitle(task.getTaskTitle().concat(task.getExpectedEndTime().toString().replace("T", " ")));
                alert.setAlertDesc(task.getTaskTitle().concat(task.getExpectedEndTime().toString().replace("T", " ")).concat("\u672a\u5b8c\u6210\u68c0\u67e5\u3002"));
                alert.setAlertSource(task.getTaskId());
                alert.setAlertTypeId(1L);
                TaskUserVo user = new TaskUserVo();
                user.setOcId(ocId);
                user.setGroupId(task.getHandleGroupId());
                user.setPositionId(task.getHandlePositionId());
                user.setAccountId(task.getHandleAccountId());
                log.info("-----------\u9884\u8b66\u4fe1\u606f\u5904\u7406\u5b8c\u6210----------");
                AccountDto accountDto = this.accountMapper.getById(ocId, user.getAccountId());
                if (accountDto == null) continue;
                EntRiskPointDto rp = this.riskPointService.getRiskPointById(ocId, rpId);
                if (StringUtils.isNotEmpty((String)accountDto.getWxId())) {
                    String r = this.QywxService.sendWeChatMessages("views/task/index", "\u4efb\u52a1\u903e\u671f\u672a\u68c0\u67e5\u901a\u77e5", alert.getAlertDesc(), accountDto.getWxId(), task.getExpectedEndTime().toString(), task.getTaskTitle(), "\u6d89\u53ca\u533a\u57df", rp.getRiskPointTitle(), "\u622a\u6b62\u65f6\u95f4", task.getExpectedEndTime().toString(), "\u5904\u7406\u4eba\u5458", accountDto.getAccountRealName());
                    log.info("-----------\u9884\u8b66\u4fe1\u606f\u5fae\u4fe1\u6d88\u606f\u53d1\u9001----------\u300b" + r);
                }
                WsClientKit.sendMessage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info("-----------\u4efb\u52a1\u903e\u671f\u5904\u7406\u5b8c\u6210----------");
    }
}

