/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.entity.ChecklistHazard;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRisk;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRiskMeasure;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.service.ChecklistHazardService;
import com.zhyc.xps.aqpt.vo.HazardTransferVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChecklistHazardServiceImpl
extends BaseService
implements ChecklistHazardService {
    @Autowired
    private ChecklistHazardMapper hazardMapper;
    @Autowired
    private ChecklistHazardRiskMapper riskMapper;
    @Autowired
    private ChecklistHazardRiskMeasureMapper measureMapper;

    @Override
    public PageBean<ChecklistHazardDto> getHazardByPage(Map<String, Object> map) {
        int page = Integer.valueOf("0" + map.get("page"));
        int limit = Integer.valueOf("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<ChecklistHazardDto> list = this.hazardMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<ChecklistHazardDto> getHazardByList(Map<String, Object> map) {
        return this.hazardMapper.getByList(map);
    }

    @Override
    public ChecklistHazardDto getHazardById(Long ocId, Long checklistId, Long hazardId) {
        return this.hazardMapper.getById(ocId, checklistId, hazardId);
    }

    @Override
    public Long createHazard(ChecklistHazard hazard) throws Exception {
        ChecklistHazardDto hazardParent;
        Long hazardId;
        Long ocId = hazard.getOcId();
        Long parentId = hazard.getParentId();
        Long checklistId = hazard.getChecklistId();
        Long parentRight = 0L;
        Long parentLevel = 0L;
        Long rootId = hazardId = Long.valueOf(IdKit.getId());
        String parentCode = "";
        if (!parentId.equals(0L) && (hazardParent = this.hazardMapper.getById(ocId, checklistId, parentId)) != null) {
            parentRight = hazardParent.getNodeRight();
            parentLevel = hazardParent.getNodeLevel();
            rootId = hazardParent.getRootId();
            parentCode = hazardParent.getHazardCode();
            this.hazardMapper.incrementRight(ocId, checklistId, 2L, parentRight);
            this.hazardMapper.incrementLeft(ocId, checklistId, 2L, parentRight);
            this.hazardMapper.updateLeaf(ocId, checklistId, parentId, 0L);
        }
        StringBuilder hazardCode = new StringBuilder();
        hazardCode.append(parentCode);
        hazardCode.append('-');
        hazardCode.append(hazardId);
        hazard.setHazardId(hazardId);
        hazard.setHazardCode(hazardCode.toString());
        hazard.setNodeLeft(parentRight);
        hazard.setNodeRight(parentRight + 1L);
        hazard.setNodeLevel(parentLevel + 1L);
        hazard.setIsLeaf(1L);
        hazard.setRootId(rootId);
        hazard.setCreatedAt(LocalDateTime.now());
        this.hazardMapper.create(hazard);
        return hazardId;
    }

    @Override
    public void updateHazard(ChecklistHazard hazard) throws Exception {
        hazard.setUpdatedAt(LocalDateTime.now());
        this.hazardMapper.update(hazard);
    }

    @Override
    public void deleteHazardById(Long ocId, Long checklistId, Long hazardId) throws Exception {
        ChecklistHazardDto hazard = this.hazardMapper.getById(ocId, checklistId, hazardId);
        if (hazard != null) {
            Long nodeLeft = hazard.getNodeLeft();
            Long nodeRight = hazard.getNodeRight();
            Long parentId = hazard.getParentId();
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("checklistId", checklistId);
            map1.put("nodeLeft", nodeLeft);
            map1.put("nodeRight", nodeRight);
            map1.put("deletedFlag", 1);
            map1.put("deletedAt", LocalDateTime.now());
            this.hazardMapper.delete(map1);
            Long steps = nodeRight - nodeLeft + 1L;
            this.hazardMapper.decrementLeft(ocId, checklistId, steps, nodeLeft);
            this.hazardMapper.decrementRight(ocId, checklistId, steps, nodeRight);
            int countOfBrothers = this.hazardMapper.countOfBrothers(ocId, checklistId, parentId);
            if (countOfBrothers < 1) {
                this.hazardMapper.updateLeaf(ocId, checklistId, parentId, 1L);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        map.put("checklistId", checklistId);
        map.put("hazardId", hazardId);
        this.hazardMapper.delete(map);
    }

    @Override
    public void transferHazard(HazardTransferVo transferVo) throws Exception {
        ChecklistHazard hazard;
        Long ocId = transferVo.getTargetOcId();
        Long targetChecklistId = transferVo.getTargetChecklistId();
        Long targetParentId = transferVo.getTargetParentId();
        Long targetHazardId = transferVo.getTargetHazardId();
        Long checklistId = transferVo.getChecklistId();
        Long hazardId = transferVo.getHazardId();
        Long opCode = transferVo.getOpCode();
        Long userId = transferVo.getUserId();
        LocalDateTime curTime = LocalDateTime.now();
        ChecklistHazardDto hazardSrc = this.hazardMapper.getChecklistHazardById(checklistId, hazardId);
        if (hazardSrc == null) {
            throw new Exception("\u5371\u9669\u6e90\u4e0d\u5b58\u5728!");
        }
        if (opCode.equals(1L)) {
            hazard = new ChecklistHazard();
            hazard.setOcId(ocId);
            hazard.setChecklistId(targetChecklistId);
            hazard.setParentId(targetParentId);
            hazard.setHazardCode(hazardSrc.getHazardCode());
            hazard.setHazardTitle(hazardSrc.getHazardTitle());
            hazard.setHazardDesc(hazardSrc.getHazardDesc());
            hazard.setHazardImage(hazardSrc.getHazardImage());
            hazard.setHazardLevel(hazardSrc.getHazardLevel());
            hazard.setHazardTypeId(hazardSrc.getHazardTypeId());
            hazard.setCreatedAt(curTime);
            hazard.setCreatedBy(userId);
            targetHazardId = this.createHazard(hazard);
        } else {
            hazard = new ChecklistHazard();
            hazard.setOcId(ocId);
            hazard.setChecklistId(targetChecklistId);
            hazard.setHazardId(targetHazardId);
            hazard.setHazardCode(hazardSrc.getHazardCode());
            hazard.setHazardTitle(hazardSrc.getHazardTitle());
            hazard.setHazardDesc(hazardSrc.getHazardDesc());
            hazard.setHazardImage(hazardSrc.getHazardImage());
            hazard.setHazardLevel(hazardSrc.getHazardLevel());
            hazard.setHazardTypeId(hazardSrc.getHazardTypeId());
            hazard.setUpdatedAt(curTime);
            hazard.setUpdatedBy(userId);
            this.hazardMapper.update(hazard);
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("checklistId", targetChecklistId);
        map1.put("hazardId", targetHazardId);
        map1.put("deletedAt", LocalDateTime.now());
        map1.put("deletedFlag", 1);
        this.riskMapper.delete(map1);
        this.measureMapper.delete(map1);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("checklistId", checklistId);
        map2.put("hazardId", hazardId);
        List<ChecklistHazardRiskDto> zkRiskList = this.riskMapper.getByList(map2);
        for (ChecklistHazardRiskDto zkRisk : zkRiskList) {
            Long riskId = IdKit.getId();
            ChecklistHazardRisk risk = new ChecklistHazardRisk();
            risk.setOcId(ocId);
            risk.setChecklistId(targetChecklistId);
            risk.setHazardId(targetHazardId);
            risk.setRiskId(riskId);
            risk.setRiskSource(zkRisk.getRiskSource());
            risk.setRiskReason(zkRisk.getRiskReason());
            risk.setRiskConsequence(zkRisk.getRiskConsequence());
            risk.setRiskCode(zkRisk.getRiskCode());
            risk.setRiskLevel(zkRisk.getRiskLevel());
            risk.setRiskTypeId(zkRisk.getRiskTypeId());
            risk.setCreatedAt(curTime);
            risk.setCreatedBy(userId);
            this.riskMapper.create(risk);
            HashMap<String, Object> map3 = new HashMap<String, Object>();
            map3.put("checklistId", checklistId);
            map3.put("hazardId", hazardId);
            map3.put("riskId", zkRisk.getRiskId());
            List<ChecklistHazardRiskMeasureDto> zkMeasureList = this.measureMapper.getByList(map3);
            for (ChecklistHazardRiskMeasureDto zkMeasure : zkMeasureList) {
                Long measureId = IdKit.getId();
                ChecklistHazardRiskMeasure measure = new ChecklistHazardRiskMeasure();
                measure.setOcId(ocId);
                measure.setChecklistId(checklistId);
                measure.setHazardId(targetHazardId);
                measure.setRiskId(riskId);
                measure.setMeasureId(measureId);
                measure.setMeasureTypeId(zkMeasure.getMeasureTypeId());
                measure.setMeasureContent(zkMeasure.getMeasureContent());
                measure.setMeasureReference(zkMeasure.getMeasureReference());
                measure.setMeasureDesc(zkMeasure.getMeasureDesc());
                measure.setCreatedAt(LocalDateTime.now());
                measure.setCreatedBy(userId);
                this.measureMapper.create(measure);
            }
        }
    }
}

