/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.EntDangerAttachDto;
import com.zhyc.xps.aqpt.dto.EntDangerDto;
import com.zhyc.xps.aqpt.entity.EntDanger;
import com.zhyc.xps.aqpt.entity.EntDangerAttach;
import com.zhyc.xps.aqpt.mapper.EntDangerAttachMapper;
import com.zhyc.xps.aqpt.mapper.EntDangerMapper;
import com.zhyc.xps.aqpt.service.EntDangerService;
import com.zhyc.xps.aqpt.vo.DangerVo;
import com.zhyc.xps.common.dto.AttachDto;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.vo.TaskUserVo;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.mapper.DocFileMapper;
import com.zhyc.xps.sys.mapper.GroupMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class EntDangerServiceImpl
extends BaseService
implements EntDangerService {
    @Resource
    EntDangerMapper dangerMapper;
    @Resource
    EntDangerAttachMapper dangerAttachMapper;
    @Resource
    DocFileMapper docFileMapper;
    @Resource
    GroupMapper groupMapper;

    @Override
    public PageBean<EntDangerDto> getDangerByPage(Map<String, Object> map) {
        Long acceptGroupId;
        GroupDto group;
        Long ocId;
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        if (map.containsKey("curGroupId")) {
            Long curGroupId;
            ocId = Long.valueOf("0" + map.get("ocId"));
            GroupDto group2 = this.groupMapper.getById(ocId, curGroupId = Long.valueOf("0" + map.get("curGroupId")));
            if (group2 != null) {
                Long nodeLeft = group2.getNodeLeft();
                Long nodeRight = group2.getNodeRight();
                map.put("curGroupNodeLeft", nodeLeft);
                map.put("curGroupNodeRight", nodeRight);
                map.remove("curGroupId");
            }
        } else if (map.containsKey("submitGroupId")) {
            Long submitGroupId;
            ocId = Long.valueOf("0" + map.get("ocId"));
            GroupDto group3 = this.groupMapper.getById(ocId, submitGroupId = Long.valueOf("0" + map.get("submitGroupId")));
            if (group3 != null) {
                Long nodeLeft = group3.getNodeLeft();
                Long nodeRight = group3.getNodeRight();
                map.put("submitGroupNodeLeft", nodeLeft);
                map.put("submitGroupNodeRight", nodeRight);
                map.remove("submitGroupId");
            }
        } else if (map.containsKey("reviewGroupId")) {
            Long reviewGroupId;
            ocId = Long.valueOf("0" + map.get("ocId"));
            GroupDto group4 = this.groupMapper.getById(ocId, reviewGroupId = Long.valueOf("0" + map.get("reviewGroupId")));
            if (group4 != null) {
                Long nodeLeft = group4.getNodeLeft();
                Long nodeRight = group4.getNodeRight();
                map.put("reviewGroupNodeLeft", nodeLeft);
                map.put("reviewGroupNodeRight", nodeRight);
                map.remove("reviewGroupId");
            }
        } else if (map.containsKey("rectifyGroupId")) {
            Long rectifyGroupId;
            ocId = Long.valueOf("0" + map.get("ocId"));
            GroupDto group5 = this.groupMapper.getById(ocId, rectifyGroupId = Long.valueOf("0" + map.get("rectifyGroupId")));
            if (group5 != null) {
                Long nodeLeft = group5.getNodeLeft();
                Long nodeRight = group5.getNodeRight();
                map.put("rectifyGroupNodeLeft", nodeLeft);
                map.put("rectifyGroupNodeRight", nodeRight);
                map.remove("rectifyGroupId");
            }
        } else if (map.containsKey("acceptGroupId") && (group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), acceptGroupId = Long.valueOf("0" + map.get("acceptGroupId")))) != null) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("acceptGroupNodeLeft", nodeLeft);
            map.put("acceptGroupNodeRight", nodeRight);
            map.remove("acceptGroupId");
        }
        PageHelper.startPage((int)page, (int)limit);
        List<EntDangerDto> list = this.dangerMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<EntDangerDto> getDangerByList(Map<String, Object> map) {
        Long acceptGroupId;
        Long ocId;
        GroupDto group;
        if (map.get("curGroupId") != null) {
            Long curGroupId;
            Long ocId2 = Long.valueOf("0" + map.get("ocId"));
            GroupDto group2 = this.groupMapper.getById(ocId2, curGroupId = Long.valueOf("0" + map.get("curGroupId")));
            if (group2 != null) {
                Long nodeLeft = group2.getNodeLeft();
                Long nodeRight = group2.getNodeRight();
                map.put("curGroupNodeLeft", nodeLeft);
                map.put("curGroupNodeRight", nodeRight);
                map.remove("curGroupId");
            }
        } else if (map.get("submitGroupId") != null) {
            Long submitGroupId;
            Long ocId3 = Long.valueOf("0" + map.get("ocId"));
            GroupDto group3 = this.groupMapper.getById(ocId3, submitGroupId = Long.valueOf("0" + map.get("submitGroupId")));
            if (group3 != null) {
                Long nodeLeft = group3.getNodeLeft();
                Long nodeRight = group3.getNodeRight();
                map.put("submitGroupNodeLeft", nodeLeft);
                map.put("submitGroupNodeRight", nodeRight);
                map.remove("submitGroupId");
            }
        } else if (map.get("reviewGroupId") != null) {
            Long reviewGroupId;
            Long ocId4 = Long.valueOf("0" + map.get("ocId"));
            GroupDto group4 = this.groupMapper.getById(ocId4, reviewGroupId = Long.valueOf("0" + map.get("reviewGroupId")));
            if (group4 != null) {
                Long nodeLeft = group4.getNodeLeft();
                Long nodeRight = group4.getNodeRight();
                map.put("reviewGroupNodeLeft", nodeLeft);
                map.put("reviewGroupNodeRight", nodeRight);
                map.remove("reviewGroupId");
            }
        } else if (map.get("rectifyGroupId") != null) {
            Long rectifyGroupId;
            Long ocId5 = Long.valueOf("0" + map.get("ocId"));
            GroupDto group5 = this.groupMapper.getById(ocId5, rectifyGroupId = Long.valueOf("0" + map.get("rectifyGroupId")));
            if (group5 != null) {
                Long nodeLeft = group5.getNodeLeft();
                Long nodeRight = group5.getNodeRight();
                map.put("rectifyGroupNodeLeft", nodeLeft);
                map.put("rectifyGroupNodeRight", nodeRight);
                map.remove("rectifyGroupId");
            }
        } else if (map.get("acceptGroupId") != null && (group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), acceptGroupId = Long.valueOf("0" + map.get("acceptGroupId")))) != null) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("acceptGroupNodeLeft", nodeLeft);
            map.put("acceptGroupNodeRight", nodeRight);
            map.remove("acceptGroupId");
        }
        return this.dangerMapper.getByList(map);
    }

    @Override
    public DangerVo getDangerById(Long ocId, Long dangerId) {
        EntDangerDto dangerDto = this.dangerMapper.getById(ocId, dangerId);
        if (dangerDto == null) {
            return null;
        }
        DangerVo vo = new DangerVo();
        BeanUtils.copyProperties((Object)dangerDto, (Object)vo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("dangerId", dangerId);
        List<EntDangerAttachDto> attachList = this.dangerAttachMapper.getByList(map);
        vo.setAttachList(attachList);
        return vo;
    }

    @Override
    public void createDanger(EntDanger danger, List<AttachDto> attachList) throws Exception {
        Long ocId = danger.getOcId();
        Long userId = danger.getCreatedBy();
        Long dangerId = danger.getDangerId();
        danger.setCreatedAt(LocalDateTime.now());
        this.dangerMapper.create(danger);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("dangerId", dangerId);
        this.dangerAttachMapper.delete(map);
        if (!ObjectUtils.isEmpty(attachList)) {
            for (AttachDto file : attachList) {
                this.attachFileAction(ocId, userId, dangerId, "submit", file);
            }
        }
    }

    private void attachFileAction(Long ocId, Long userId, Long dangerId, String formCode, AttachDto attachDto) throws Exception {
        Long fileId = attachDto.getFileId();
        EntDangerAttach dangerAttach = new EntDangerAttach();
        dangerAttach.setOcId(ocId);
        dangerAttach.setDangerId(dangerId);
        dangerAttach.setTaskCode(formCode);
        dangerAttach.setFileId(fileId);
        dangerAttach.setCreatedBy(userId);
        dangerAttach.setCreatedAt(LocalDateTime.now());
        this.dangerAttachMapper.create(dangerAttach);
    }

    @Override
    public void deleteDanger(Map<String, Object> map) throws Exception {
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        this.dangerMapper.delete(map);
    }

    @Override
    public void handleDanger(TaskUserVo user, DangerVo vo) throws Exception {
        EntDangerDto dto;
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long dangerId = vo.getDangerId();
        Long status = vo.getStatus();
        String formCode = vo.getFormCode();
        EntDanger danger = new EntDanger();
        danger.setOcId(ocId);
        danger.setDangerId(dangerId);
        danger.setStatus(status);
        if ("submit".equals(formCode)) {
            danger.setSubmitAccountId(userId);
            danger.setSubmitAccountName(user.getAccountName());
            danger.setSubmitPositionId(user.getPositionId());
            danger.setSubmitPositionName(user.getPositionName());
            danger.setSubmitGroupId(user.getGroupId());
            danger.setSubmitGroupName(user.getGroupName());
            danger.setSubmitTime(LocalDateTime.now());
            danger.setSubmitRemark(vo.getSubmitRemark());
            danger.setDangerTitle(vo.getDangerTitle());
            danger.setDangerCatId(vo.getDangerCatId());
            danger.setDangerCode(vo.getDangerCode());
            danger.setDangerLevel(vo.getDangerLevel());
            danger.setDangerDeadLine(vo.getDangerDeadLine());
            danger.setDangerDesc(vo.getDangerDesc());
            danger.setScenePhoto(vo.getScenePhoto());
            danger.setSceneIcon(vo.getSceneIcon());
        } else if ("review".equals(formCode)) {
            danger.setReviewAccountId(userId);
            danger.setReviewAccountName(user.getAccountName());
            danger.setReviewPositionId(user.getPositionId());
            danger.setReviewPositionName(user.getPositionName());
            danger.setReviewGroupId(user.getGroupId());
            danger.setReviewGroupName(user.getGroupName());
            danger.setReviewTime(LocalDateTime.now());
            danger.setReviewRemark(vo.getReviewRemark());
        } else if ("rectify".equals(formCode)) {
            danger.setRectifyAccountId(userId);
            danger.setRectifyAccountName(user.getAccountName());
            danger.setRectifyPositionId(user.getPositionId());
            danger.setRectifyPositionName(user.getPositionName());
            danger.setRectifyGroupId(user.getGroupId());
            danger.setRectifyGroupName(user.getGroupName());
            danger.setRectifyTime(LocalDateTime.now());
            danger.setDangerReason(vo.getDangerReason());
            danger.setRectifyCat(vo.getRectifyCat());
            danger.setRectifyMeasure(vo.getRectifyMeasure());
            danger.setRectifyRemark(vo.getRectifyRemark());
        } else if ("accept".equals(formCode)) {
            danger.setAcceptAccountId(userId);
            danger.setAcceptAccountName(user.getAccountName());
            danger.setAcceptPositionId(user.getPositionId());
            danger.setAcceptPositionName(user.getPositionName());
            danger.setAcceptGroupId(user.getGroupId());
            danger.setAcceptGroupName(user.getGroupName());
            danger.setAcceptTime(LocalDateTime.now());
            danger.setAcceptRemark(vo.getAcceptRemark());
        }
        if (status.equals(1L) || status.equals(-1L)) {
            danger.setFinishTime(LocalDateTime.now());
        }
        if (ObjectUtils.isEmpty((Object)(dto = this.dangerMapper.getById(ocId, dangerId)))) {
            danger.setCreatedBy(userId);
            danger.setCreatedAt(LocalDateTime.now());
            this.dangerMapper.create(danger);
        } else {
            danger.setUpdatedBy(userId);
            danger.setUpdatedAt(LocalDateTime.now());
            this.dangerMapper.update(danger);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("dangerId", dangerId);
        map.put("formCode", formCode);
        this.dangerAttachMapper.delete(map);
        List<EntDangerAttachDto> attachList = vo.getAttachList();
        if (!ObjectUtils.isEmpty(attachList)) {
            for (AttachDto attachDto : attachList) {
                this.attachFileAction(ocId, userId, dangerId, formCode, attachDto);
            }
        }
    }
}

