/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointChecklistDto;
import com.zhyc.xps.aqpt.entity.EntRiskPointChecklist;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMapper;
import com.zhyc.xps.aqpt.mapper.ChecklistHazardRiskMeasureMapper;
import com.zhyc.xps.aqpt.mapper.EntRiskPointChecklistMapper;
import com.zhyc.xps.aqpt.service.EntRiskPointChecklistService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.aqpt.vo.HazardChecklistVo;
import com.zhyc.xps.common.dto.ChecklistDto;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.mapper.ChecklistMapper;
import com.zhyc.xps.common.service.BaseService;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class EntRiskPointChecklistServiceImpl
extends BaseService
implements EntRiskPointChecklistService {
    @Resource
    EntRiskPointChecklistMapper riskPointChecklistMapper;
    @Resource
    ChecklistMapper checklistMapper;
    @Resource
    ChecklistHazardMapper hazardMapper;
    @Resource
    ChecklistHazardRiskMapper riskMapper;
    @Resource
    ChecklistHazardRiskMeasureMapper measureMapper;

    @Override
    public PageBean<EntRiskPointChecklistDto> getRiskPointChecklistByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EntRiskPointChecklistDto> list = this.riskPointChecklistMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public List<EntRiskPointChecklistDto> getRiskPointChecklistByList(Map<String, Object> map) {
        return this.riskPointChecklistMapper.getByList(map);
    }

    @Override
    public EntRiskPointChecklistDto getRiskPointChecklistById(Long ocId, Long riskPointId, Long checklistId) {
        return this.riskPointChecklistMapper.getById(ocId, riskPointId, checklistId);
    }

    @Override
    public void createRiskPointChecklist(EntRiskPointChecklist riskPointChecklist) throws Exception {
        riskPointChecklist.setCreatedAt(LocalDateTime.now());
        this.riskPointChecklistMapper.create(riskPointChecklist);
    }

    @Override
    public void deleteRiskPointChecklist(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.riskPointChecklistMapper.delete(map);
    }

    @Override
    public PageBean<ChecklistDto> getSelectChecklistByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        Long ocId = Long.valueOf("0" + map.get("ocId"));
        PageHelper.startPage((int)page, (int)limit);
        List<ChecklistDto> list = this.riskPointChecklistMapper.getSelectByPage(map);
        return new PageBean(list);
    }

    @Override
    public HazardChecklistVo getRiskPointChecklistViewById(Long ocId, Long riskPointId, Long checklistId) {
        ChecklistDto checklist = this.checklistMapper.getById(ocId, checklistId);
        if (ObjectUtils.isEmpty((Object)checklist)) {
            return null;
        }
        Long checklistTypeId = checklist.getChecklistTypeId();
        HazardChecklistVo hazardChecklistVo = new HazardChecklistVo();
        hazardChecklistVo.setChecklistId(checklistId);
        hazardChecklistVo.setChecklistTitle(checklist.getChecklistTitle());
        hazardChecklistVo.setChecklistTypeId(checklistTypeId);
        hazardChecklistVo.setChecklistCatId(checklist.getChecklistCatId());
        hazardChecklistVo.setChecklistCatTitle(checklist.getChecklistCatTitle());
        hazardChecklistVo.setChecklistDesc(checklist.getChecklistDesc());
        hazardChecklistVo.setAuthor(checklist.getAuthor());
        hazardChecklistVo.setVersion(checklist.getVersion());
        hazardChecklistVo.setIsFixed(checklist.getIsFixed());
        hazardChecklistVo.setIssuedAccountId(checklist.getIssuedAccountId());
        hazardChecklistVo.setIssuedAccountName(checklist.getIssuedAccountName());
        hazardChecklistVo.setIssuedAt(checklist.getIssuedAt());
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        if (checklistTypeId == 1L) {
            map1.put("riskPointId", riskPointId);
            map1.put("checklistId", ocId);
            map1.put("ctrlLevelId", checklistId);
        } else {
            map1.put("checklistId", checklistId);
        }
        List<ChecklistHazardDto> hazardList = this.hazardMapper.getByList(map1);
        List<ChecklistHazardRiskDto> riskList = this.riskMapper.getByList(map1);
        List<ChecklistHazardRiskMeasureDto> measureList = this.measureMapper.getByList(map1);
        ArrayList<ChecklistHazardVo> hazardVoList = new ArrayList<ChecklistHazardVo>();
        for (ChecklistHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            ChecklistHazardVo hazardVo = new ChecklistHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<ChecklistHazardRiskMeasureDto> measureVoList = new ArrayList<ChecklistHazardRiskMeasureDto>();
                for (ChecklistHazardRiskMeasureDto measure : measureList) {
                    measure.setHazardTitle(riskVo.getHazardTitle());
                    measure.setHazardCode(hazardVo.getHazardCode());
                    measure.setRiskSource(riskVo.getRiskSource());
                    measure.setRiskCode(riskVo.getRiskCode());
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    measureVoList.add(measure);
                }
                riskVo.setMeasureList(measureVoList);
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVoList.add(hazardVo);
        }
        hazardChecklistVo.setHazardList(hazardVoList);
        return hazardChecklistVo;
    }
}

