/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.EntRiskPointDetailDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointMapLayerDto;
import com.zhyc.xps.aqpt.entity.EntRiskPoint;
import com.zhyc.xps.aqpt.mapper.EntRiskPointMapLayerMapper;
import com.zhyc.xps.aqpt.mapper.EntRiskPointMapper;
import com.zhyc.xps.aqpt.service.EntRiskPointService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.mapper.GroupMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class EntRiskPointServiceImpl
extends BaseService
implements EntRiskPointService {
    @Resource
    EntRiskPointMapper riskPointMapper;
    @Resource
    EntRiskPointMapLayerMapper riskPointMapLayerMapper;
    @Resource
    GroupMapper groupMapper;

    @Override
    public PageBean<EntRiskPointDto> getRiskPointByPage(Map<String, Object> map) {
        Long groupId;
        Long ocId;
        GroupDto group;
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        if (map.containsKey("groupId") && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), groupId = Long.valueOf("0" + map.get("groupId")))))) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.remove("groupId");
        }
        PageHelper.startPage((int)page, (int)limit);
        List<EntRiskPointDto> list = this.riskPointMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public EntRiskPointDetailDto getRiskPointDetailById(Long ocId, Long riskPointId) {
        EntRiskPointDto rp = this.riskPointMapper.getById(ocId, riskPointId);
        if (ObjectUtils.isEmpty((Object)rp)) {
            return null;
        }
        EntRiskPointDetailDto rpDetail = new EntRiskPointDetailDto();
        rpDetail.setRiskPointId(rp.getRiskPointId());
        rpDetail.setRiskPointTitle(rp.getRiskPointTitle());
        rpDetail.setRiskPointCode(rp.getRiskPointCode());
        rpDetail.setRiskPointAddr(rp.getRiskPointAddr());
        rpDetail.setRiskPointCatId(rp.getRiskPointCatId());
        rpDetail.setRiskPointCatTitle(rp.getRiskPointCatTitle());
        rpDetail.setGroupId(rp.getGroupId());
        rpDetail.setGroupName(rp.getGroupName());
        rpDetail.setRiskPointDesc(rp.getRiskPointDesc());
        rpDetail.setActiveStartTime(rp.getActiveStartTime());
        rpDetail.setActiveEndTime(rp.getActiveEndTime());
        rpDetail.setRiskPointLevel(rp.getRiskPointLevel());
        rpDetail.setStatus(rp.getStatus());
        rpDetail.setIsActive(rp.getIsActive());
        rpDetail.setIsMajorHazard(rp.getIsMajorHazard());
        rpDetail.setRiskPointPhoto(rp.getRiskPointPhoto());
        EntRiskPointMapLayerDto data = this.riskPointMapLayerMapper.getById(ocId, riskPointId);
        rpDetail.setMapLayer(data);
        return rpDetail;
    }

    @Override
    public List<EntRiskPointDto> getRiskPointByList(Map<String, Object> map) {
        Long groupId;
        Long ocId;
        GroupDto group;
        if (map.containsKey("groupId") && !ObjectUtils.isEmpty((Object)(group = this.groupMapper.getById(ocId = Long.valueOf("0" + map.get("ocId")), groupId = Long.valueOf("0" + map.get("groupId")))))) {
            Long nodeLeft = group.getNodeLeft();
            Long nodeRight = group.getNodeRight();
            map.put("nodeLeft", nodeLeft);
            map.put("nodeRight", nodeRight);
            map.remove("groupId");
        }
        return this.riskPointMapper.getByList(map);
    }

    @Override
    public EntRiskPointDto getRiskPointById(Long ocId, Long riskPointId) {
        return this.riskPointMapper.getById(ocId, riskPointId);
    }

    @Override
    public EntRiskPointDto getRiskPointByCode(Long ocId, String riskPointCode) {
        return this.riskPointMapper.getByCode(ocId, riskPointCode);
    }

    @Override
    public void createRiskPoint(EntRiskPoint riskPoint) throws Exception {
        Long riskPointId = IdKit.getId();
        riskPoint.setRiskPointId(riskPointId);
        riskPoint.setCreatedAt(LocalDateTime.now());
        this.riskPointMapper.create(riskPoint);
    }

    @Override
    public void updateRiskPoint(EntRiskPoint riskPoint) throws Exception {
        riskPoint.setUpdatedAt(LocalDateTime.now());
        this.riskPointMapper.update(riskPoint);
    }

    @Override
    public void deleteRiskPoint(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.riskPointMapper.delete(map);
    }

    @Override
    public void deleteRiskPointById(Long ocId, Long riskPointId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("riskPointId", riskPointId);
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.riskPointMapper.delete(map);
    }
}

