/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.EquipmentDto;
import com.zhyc.xps.aqpt.dto.EquipmentMapLayerDto;
import com.zhyc.xps.aqpt.entity.Equipment;
import com.zhyc.xps.aqpt.mapper.EquipmentMapper;
import com.zhyc.xps.aqpt.service.EquipmentService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.sys.entity.EntMapLayer;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class EquipmentServiceImpl
extends BaseService
implements EquipmentService {
    @Resource
    EquipmentMapper equipmentMapper;
    @Resource
    EntMapLayerMapper mapLayerMapper;

    @Override
    public PageBean<EquipmentDto> getEquipmentByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EquipmentDto> list = this.equipmentMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public EquipmentDto getEquipmentById(Long ocId, Long equipId) {
        return this.equipmentMapper.getById(ocId, equipId);
    }

    @Override
    public EquipmentDto getEquipmentByCode(Long ocId, String equipCode) {
        return this.equipmentMapper.getByCode(ocId, equipCode);
    }

    @Override
    public List<EquipmentDto> getEquipmentByList(Map<String, Object> map) {
        return this.equipmentMapper.getByList(map);
    }

    @Override
    public void createEquipment(Equipment map) throws Exception {
        map.setEquipId(IdKit.getId());
        map.setCreatedAt(LocalDateTime.now());
        this.equipmentMapper.create(map);
    }

    @Override
    public void updateEquipment(Equipment equip) throws Exception {
        equip.setUpdatedAt(LocalDateTime.now());
        this.equipmentMapper.update(equip);
    }

    @Override
    public void updateEquipmentMapLayer(EquipmentMapLayerDto layerDto) throws Exception {
        Long ocId = layerDto.getOcId();
        Long equipId = layerDto.getEquipId();
        Long userId = layerDto.getUpdatedBy();
        EquipmentDto equip = this.getEquipmentById(ocId, equipId);
        if (ObjectUtils.isEmpty((Object)equip)) {
            throw new Exception("\u8bbe\u5907\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        Long layerId = equip.getLayerId();
        EntMapLayer mapLayer = new EntMapLayer();
        BeanUtils.copyProperties((Object)((Object)layerDto), (Object)mapLayer);
        if (layerId == null) {
            layerId = IdKit.getId();
            mapLayer.setLayerId(layerId);
            mapLayer.setCreatedAt(LocalDateTime.now());
            mapLayer.setCreatedBy(userId);
            this.mapLayerMapper.create(mapLayer);
            Equipment equipment = new Equipment();
            equipment.setOcId(ocId);
            equipment.setEquipId(equipId);
            equipment.setLayerId(layerId);
            equipment.setUpdatedAt(LocalDateTime.now());
            equipment.setUpdatedBy(userId);
            this.equipmentMapper.update(equipment);
        } else {
            mapLayer.setUpdatedAt(LocalDateTime.now());
            mapLayer.setUpdatedBy(userId);
            this.mapLayerMapper.update(mapLayer);
        }
    }

    @Override
    public void deleteEquipment(Map<String, Object> map) throws Exception {
        Long ocId = Long.valueOf(map.get("ocId").toString());
        Long equipId = Long.valueOf(map.get("equipId").toString());
        Long userId = Long.valueOf(map.get("deletedBy").toString());
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        map2.put("ocId", ocId);
        map2.put("layerId", equipId);
        this.mapLayerMapper.delete(map2);
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.equipmentMapper.delete(map);
    }
}

