/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.aqpt.dto.CheckDefDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskMeasureDto;
import com.zhyc.xps.aqpt.dto.EntDangerDto;
import com.zhyc.xps.aqpt.dto.EntRiskPointHazardDto;
import com.zhyc.xps.aqpt.mapper.CheckDefMapper;
import com.zhyc.xps.aqpt.mapper.EntDangerMapper;
import com.zhyc.xps.aqpt.mapper.ReportMapper;
import com.zhyc.xps.aqpt.service.ReportService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardDutyVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.aqpt.vo.ChecklistHazardVo;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.sys.dto.EntGridDto;
import com.zhyc.xps.sys.mapper.EntGridMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReportServiceImpl
extends BaseService
implements ReportService {
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private EntGridMapper gridMapper;
    @Autowired
    private EntDangerMapper dangerMapper;
    @Autowired
    private CheckDefMapper checkDefMapper;

    @Override
    public List<EntGridDto> getGridByList(Map<String, Object> map) {
        return this.gridMapper.getByList(map);
    }

    @Override
    public PageBean<EntDangerDto> getDangerByPage(Map<String, Object> map) {
        int page = Integer.valueOf("0" + map.get("page"));
        int limit = Integer.valueOf("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<EntDangerDto> list = this.dangerMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<ChecklistHazardVo> getRiskPointHazardViewByList(Map<String, Object> map) {
        List<EntRiskPointHazardDto> hazardList = this.reportMapper.getHazardByList(map);
        List<ChecklistHazardRiskDto> riskList = this.reportMapper.getRiskByList(map);
        List<ChecklistHazardRiskMeasureDto> measureList = this.reportMapper.getMeasureByList(map);
        ArrayList<ChecklistHazardVo> hazardVoList = new ArrayList<ChecklistHazardVo>();
        for (EntRiskPointHazardDto hazardDto : hazardList) {
            Long hazardId = hazardDto.getHazardId();
            ChecklistHazardVo hazardVo = new ChecklistHazardVo();
            hazardVo.setHazardId(hazardId);
            hazardVo.setRiskPointTitle(hazardDto.getRiskPointTitle());
            hazardVo.setRiskPointId(hazardDto.getRiskPointId());
            hazardVo.setGroupName(hazardDto.getGroupName());
            hazardVo.setHazardCode(hazardDto.getHazardCode());
            hazardVo.setHazardTitle(hazardDto.getHazardTitle());
            hazardVo.setHazardDesc(hazardDto.getHazardDesc());
            hazardVo.setHazardLevel(hazardDto.getHazardLevel());
            hazardVo.setHazardImage(hazardDto.getHazardImage());
            hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
            hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
            ArrayList<ChecklistHazardRiskVo> riskVoList = new ArrayList<ChecklistHazardRiskVo>();
            for (ChecklistHazardRiskDto risk : riskList) {
                if (risk.getHazardId().longValue() != hazardId.longValue()) continue;
                Long riskId = risk.getRiskId();
                ChecklistHazardRiskVo riskVo = new ChecklistHazardRiskVo();
                riskVo.setRiskId(riskId);
                riskVo.setRiskCode(risk.getRiskCode());
                riskVo.setRiskSource(risk.getRiskSource());
                riskVo.setRiskReason(risk.getRiskReason());
                riskVo.setRiskConsequence(risk.getRiskConsequence());
                riskVo.setRiskTypeId(risk.getRiskTypeId());
                riskVo.setRiskLevel(risk.getRiskLevel());
                ArrayList<ChecklistHazardRiskMeasureDto> measureVoList = new ArrayList<ChecklistHazardRiskMeasureDto>();
                for (ChecklistHazardRiskMeasureDto measure : measureList) {
                    Long mHazardId = measure.getHazardId();
                    Long mRiskId = measure.getRiskId();
                    if (mHazardId.longValue() != hazardId.longValue() || mRiskId.longValue() != riskId.longValue()) continue;
                    measureVoList.add(measure);
                }
                riskVo.setMeasureList(measureVoList);
                riskVoList.add(riskVo);
            }
            hazardVo.setRiskList(riskVoList);
            hazardVoList.add(hazardVo);
        }
        return hazardVoList;
    }

    @Override
    public List<ChecklistHazardDutyVo> getRiskPointHazardDutyViewByList(Map<String, Object> map) {
        List<CheckDefDto> checkDefList = this.checkDefMapper.getByList(map);
        List<EntRiskPointHazardDto> hazardList = this.reportMapper.getHazardByCheckDefList(map);
        ArrayList<ChecklistHazardDutyVo> hazardVoList = new ArrayList<ChecklistHazardDutyVo>();
        for (CheckDefDto cdd : checkDefList) {
            ArrayList<ChecklistHazardVo> checklistHazardVos = new ArrayList<ChecklistHazardVo>();
            ChecklistHazardDutyVo checklistHazardDutyVo = new ChecklistHazardDutyVo();
            checklistHazardDutyVo.setCheckDesc(cdd.getCheckDesc());
            checklistHazardDutyVo.setCheckDefId(cdd.getCheckDefId());
            checklistHazardDutyVo.setRiskPointTitle(cdd.getRiskPointTitle());
            checklistHazardDutyVo.setRiskPointId(cdd.getRiskPointId());
            checklistHazardDutyVo.setCheckTitle(cdd.getCheckTitle());
            checklistHazardDutyVo.setGroupName(cdd.getGroupName());
            checklistHazardDutyVo.setAccountName(cdd.getAccountName());
            for (EntRiskPointHazardDto hazardDto : hazardList) {
                if (!cdd.getRiskPointId().equals(hazardDto.getRiskPointId()) || !cdd.getCheckDefId().equals(hazardDto.getCheckDefId())) continue;
                Long hazardId = hazardDto.getHazardId();
                ChecklistHazardVo hazardVo = new ChecklistHazardVo();
                hazardVo.setHazardId(hazardId);
                hazardVo.setRiskPointTitle(hazardDto.getRiskPointTitle());
                hazardVo.setRiskPointId(hazardDto.getRiskPointId());
                hazardVo.setGroupName(hazardDto.getGroupName());
                hazardVo.setHazardCode(hazardDto.getHazardCode());
                hazardVo.setHazardTitle(hazardDto.getHazardTitle());
                hazardVo.setHazardDesc(hazardDto.getHazardDesc());
                hazardVo.setHazardLevel(hazardDto.getHazardLevel());
                hazardVo.setHazardImage(hazardDto.getHazardImage());
                hazardVo.setHazardTypeId(hazardDto.getHazardTypeId());
                hazardVo.setHazardTypeTitle(hazardDto.getHazardTypeTitle());
                checklistHazardVos.add(hazardVo);
            }
            checklistHazardDutyVo.setHazardList(checklistHazardVos);
            hazardVoList.add(checklistHazardDutyVo);
        }
        return hazardVoList;
    }
}

