/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfActivityActionDefDto;
import com.zhyc.xps.bpm.entity.WfActivityActionDef;
import com.zhyc.xps.bpm.service.WfActivityActionDefService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/activity/action/def"})
public class WfActivityActionDefController
extends BaseController {
    @Resource
    WfActivityActionDefService wfActivityActionDefService;

    @GetMapping(value={"/page"})
    public PageResult getWfActivityActionDefByPage(@RequestParam Map<String, Object> map) {
        PageBean<WfActivityActionDefDto> data = this.wfActivityActionDefService.getWfActivityActionDefByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{wfDefId}/{activityDefId}"})
    public JsonResult getWfActivityActionDefByList(@PathVariable Long wfDefId, @PathVariable Long activityDefId) {
        List<WfActivityActionDefDto> data = this.wfActivityActionDefService.getWfActivityActionDefByList(wfDefId, activityDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{wfDefId}/{activityDefId}/{actionId}"})
    public JsonResult getWfActivityActionDefById(@PathVariable Long wfDefId, @PathVariable Long activityDefId, @PathVariable Long actionId) {
        WfActivityActionDefDto data = this.wfActivityActionDefService.getWfActivityActionDefById(wfDefId, activityDefId, actionId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createWfAction(@RequestBody WfActivityActionDef wfActivityAction) throws CustomException {
        wfActivityAction.setCreatedBy(this.getCurUserId());
        try {
            this.wfActivityActionDefService.createWfActivityActionDef(wfActivityAction);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateWfActivityActionDef(@RequestBody WfActivityActionDef wfActivityActionDef) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            wfActivityActionDef.setUpdatedBy(userId);
            this.wfActivityActionDefService.updateWfActivityActionDef(wfActivityActionDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{wfDefId}/{activityDefId}/{actionId}"})
    public JsonResult deleteWfActivityActionDefById(@PathVariable Long wfDefId, @PathVariable Long activityDefId, @PathVariable Long actionId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("wfDefId", wfDefId);
            map.put("activityDefId", activityDefId);
            map.put("actionId", actionId);
            map.put("deletedBy", userId);
            this.wfActivityActionDefService.deleteWfActivityActionDef(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

