/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfActivityDefDto;
import com.zhyc.xps.bpm.entity.WfActivityDef;
import com.zhyc.xps.bpm.service.WfActivityDefService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/activity/def"})
public class WfActivityDefController
extends BaseController {
    @Resource
    WfActivityDefService wfActivityDefService;

    @GetMapping(value={"/page"})
    public PageResult getWfActivityDefByPage(@RequestParam Map<String, Object> map) {
        PageBean<WfActivityDefDto> data = this.wfActivityDefService.getWfActivityDefByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{wfDefId}"})
    public JsonResult getWfActivityDefByList(@PathVariable Long wfDefId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wfDefId", wfDefId);
        List<WfActivityDefDto> data = this.wfActivityDefService.getWfActivityDefByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{wfDefId}/{activityDefId}"})
    public JsonResult getWfActivityDefById(@PathVariable Long wfDefId, @PathVariable Long activityDefId) {
        WfActivityDefDto data = this.wfActivityDefService.getWfActivityDefById(wfDefId, activityDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createWfActivityDef(@RequestBody WfActivityDef activityDef) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            activityDef.setCreatedBy(userId);
            this.wfActivityDefService.createWfActivityDef(activityDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateWfActivityDef(@RequestBody WfActivityDef activityDef) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            activityDef.setUpdatedBy(userId);
            this.wfActivityDefService.updateWfActivityDef(activityDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{wfDefId}/{activityDefId}"})
    public JsonResult deleteWfActivityDefById(@PathVariable Long wfDefId, @PathVariable Long activityDefId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("wfDefId", wfDefId);
            map.put("activityDefId", activityDefId);
            map.put("deletedBy", userId);
            this.wfActivityDefService.deleteWfActivityDef(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

