/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfActivityInsDto;
import com.zhyc.xps.bpm.entity.WfActivityIns;
import com.zhyc.xps.bpm.service.WfActivityInsService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/activity/ins"})
public class WfActivityInsController
extends BaseController {
    @Resource
    WfActivityInsService wfActivityInsService;

    @GetMapping(value={"/page"})
    public PageResult getWfActivityInsByPage(@RequestParam Map<String, Object> map) {
        PageBean<WfActivityInsDto> pageInfo = this.wfActivityInsService.getWfActivityInsByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={""})
    public JsonResult getWfActivityInsByList(@RequestParam Map<String, Object> map) {
        List<WfActivityInsDto> data = this.wfActivityInsService.getWfActivityInsByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{ocId}/{wfInsId}/{ActivityInsId}"})
    public JsonResult getWfActivityInsById(@PathVariable Long ocId, @PathVariable Long wfInsId, @PathVariable Long ActivityInsId) {
        WfActivityInsDto data = this.wfActivityInsService.getWfActivityInsById(ocId, wfInsId, ActivityInsId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createWfActivityIns(@RequestBody WfActivityIns ActivityIns) throws CustomException {
        ActivityIns.setCreatedBy(this.getCurUserId());
        try {
            this.wfActivityInsService.createWfActivityIns(ActivityIns);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateWfActivityIns(@RequestBody WfActivityIns ActivityIns) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            ActivityIns.setUpdatedBy(userId);
            this.wfActivityInsService.updateWfActivityIns(ActivityIns);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{ocId}/{wfInsId}/{activityInsId}"})
    public JsonResult deleteWfActivityIns(@PathVariable Long ocId, @PathVariable Long wfInsId, @PathVariable Long activityInsId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("wfInsId", wfInsId);
            map.put("activityInsId", activityInsId);
            map.put("deletedBy", userId);
            this.wfActivityInsService.deleteWfActivityIns(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

