/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfActivityMemberDto;
import com.zhyc.xps.bpm.entity.WfActivityMember;
import com.zhyc.xps.bpm.service.WfActivityMemberService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/activity/member"})
public class WfActivityMemberController
extends BaseController {
    @Resource
    WfActivityMemberService activityMemberService;

    @GetMapping(value={"/{wfDefId}"})
    public JsonResult getWfActivityMemberList(@PathVariable Long wfDefId) {
        Long ocId = this.getCurOcId();
        List<WfActivityMemberDto> data = this.activityMemberService.getWfActivityMemberByList(ocId, wfDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createWfActivityMember(@RequestBody WfActivityMember activityMember) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            activityMember.setOcId(ocId);
            this.activityMemberService.createWfActivityMember(activityMember);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{wfDefId}/{activityDefId}"})
    public JsonResult deleteWfActivityMemberById(@PathVariable Long wfDefId, @PathVariable Long activityDefId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.activityMemberService.deleteWfActivityMemberById(ocId, wfDefId, activityDefId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

