/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.zhyc.xps.bpm.dto.WfInsDto;
import com.zhyc.xps.bpm.service.WfService;
import com.zhyc.xps.bpm.vo.WfActivityActionInsVo;
import com.zhyc.xps.bpm.vo.WfInsVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.vo.TaskUserVo;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf"})
public class WfController
extends BaseController {
    @Resource
    WfService wfService;

    @GetMapping(value={"/start/{wfDefId}"})
    public JsonResult startWfIns(@PathVariable Long wfDefId) throws CustomException {
        WfInsVo insVo;
        Long ocId = this.getCurOcId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(this.getCurUserGroupId());
        user.setGroupName(this.getCurUserGroupName());
        user.setPositionId(this.getCurUserPositionId());
        user.setPositionName(this.getCurUserPositionName());
        user.setAccountId(this.getCurUserId());
        user.setAccountName(this.getCurUserName());
        try {
            insVo = this.wfService.createWfIns(user, wfDefId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u83b7\u53d6\u6210\u529f", insVo);
    }

    @GetMapping(value={"/getinslist"})
    public JsonResult getInsByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<WfInsDto> data = this.wfService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/getinsall/page"})
    public PageResult getInsBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<WfInsDto> data = this.wfService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/getIns/{wfInsId}"})
    public JsonResult getWfInsInfoById(@PathVariable Long wfInsId) throws CustomException {
        Long ocId = this.getCurOcId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(this.getCurUserGroupId());
        user.setGroupName(this.getCurUserGroupName());
        user.setPositionId(this.getCurUserPositionId());
        user.setPositionName(this.getCurUserPositionName());
        user.setAccountId(this.getCurUserId());
        user.setAccountName(this.getCurUserName());
        WfInsVo wfInsVo = this.wfService.getWfInsById(user, wfInsId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", wfInsVo);
    }

    @PostMapping(value={"/handle"})
    public JsonResult handleWfIns(@RequestBody Map<String, Object> map) throws CustomException {
        WfInsDto wfInsDto;
        JSONObject json = new JSONObject(map);
        WfActivityActionInsVo actionVo = (WfActivityActionInsVo)json.to(WfActivityActionInsVo.class, new JSONReader.Feature[0]);
        TaskUserVo user = new TaskUserVo();
        user.setOcId(this.getCurOcId());
        user.setGroupId(this.getCurUserGroupId());
        user.setGroupName(this.getCurUserGroupName());
        user.setPositionId(this.getCurUserPositionId());
        user.setPositionName(this.getCurUserPositionName());
        user.setAccountId(this.getCurUserId());
        user.setAccountName(this.getCurUserName());
        try {
            wfInsDto = this.wfService.handleWfIns(user, actionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5904\u7406\u5b8c\u6210", wfInsDto);
    }

    @GetMapping(value={"/cancel/{wfInsId}"})
    public JsonResult CancelWfIns(@PathVariable Long wfInsId) throws CustomException {
        TaskUserVo user = new TaskUserVo();
        user.setOcId(this.getCurOcId());
        user.setGroupId(this.getCurUserGroupId());
        user.setGroupName(this.getCurUserGroupName());
        user.setPositionId(this.getCurUserPositionId());
        user.setPositionName(this.getCurUserPositionName());
        user.setAccountId(this.getCurUserId());
        user.setAccountName(this.getCurUserName());
        try {
            this.wfService.cancelWfIns(user, wfInsId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u64cd\u4f5c\u6210\u529f");
    }
}

