/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfDefDto;
import com.zhyc.xps.bpm.entity.WfDef;
import com.zhyc.xps.bpm.service.WfDefService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/def"})
public class WfDefController
extends BaseController {
    @Resource
    WfDefService wfService;

    @GetMapping(value={"/page"})
    public PageResult getWfDefByPage(@RequestParam Map<String, Object> map) {
        PageBean<WfDefDto> data = this.wfService.getWfDefByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getWfDefByList(@RequestParam Map<String, Object> map) {
        List<WfDefDto> wf = this.wfService.getWfDefByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", wf);
    }

    @GetMapping(value={"/{wfDefId}"})
    public JsonResult getWfDefById(@PathVariable Long wfDefId) {
        WfDefDto data = this.wfService.getWfDefById(wfDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createWfDef(@RequestBody WfDef wfDef) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            wfDef.setCreatedBy(userId);
            this.wfService.createWfDef(wfDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateWfDef(@RequestBody WfDef wfDef) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            wfDef.setUpdatedBy(userId);
            this.wfService.updateWfDef(wfDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{wfDefId}"})
    public JsonResult deleteWfDefById(@PathVariable Long wfDefId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("wfDefId", wfDefId);
            map.put("deletedBy", userId);
            this.wfService.deleteWfDef(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

