/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.zhyc.xps.bpm.dto.WfExampleInsDto;
import com.zhyc.xps.bpm.entity.WfExample;
import com.zhyc.xps.bpm.service.WfExampleService;
import com.zhyc.xps.bpm.vo.WfActivityActionInsVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.vo.TaskUserVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/example"})
public class WfExampleController
extends BaseController {
    @Resource
    WfExampleService exampleService;

    @GetMapping(value={"/page"})
    public PageResult getExampleByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<WfExampleInsDto> data = this.exampleService.getWfExampleByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getExampleByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<WfExampleInsDto> data = this.exampleService.getWfExampleList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{exampleId}"})
    public JsonResult getExampleById(@PathVariable Long exampleId) {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long userGroupId = this.getCurUserGroupId();
        Long userPositionId = this.getCurUserPositionId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(userGroupId);
        user.setPositionId(userPositionId);
        user.setAccountId(userId);
        WfExampleInsDto wfExample = this.exampleService.getWfExampleById(ocId, exampleId);
        HashMap<String, WfExampleInsDto> map = new HashMap<String, WfExampleInsDto>();
        map.put("data", wfExample);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", map);
    }

    @DeleteMapping(value={"/{exampleId}"})
    public JsonResult deleteExampleById(@PathVariable Long exampleId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.exampleService.deleteWfExampleById(ocId, exampleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/start"})
    public JsonResult startExampleIns() throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long userGroupId = this.getCurUserGroupId();
        Long userPositionId = this.getCurUserPositionId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(userGroupId);
        user.setPositionId(userPositionId);
        user.setAccountId(userId);
        Object insVo = null;
        return this.resultOk("\u4fdd\u5b58\u6210\u529f", insVo);
    }

    @PostMapping(value={"/submit"})
    public JsonResult submitExampleIns(@RequestBody Map<String, Object> map) throws CustomException {
        JSONObject json = new JSONObject(map);
        WfExample example = (WfExample)((Object)json.to(WfExample.class, new JSONReader.Feature[0]));
        WfActivityActionInsVo actionVo = (WfActivityActionInsVo)json.to(WfActivityActionInsVo.class, new JSONReader.Feature[0]);
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long userGroupId = this.getCurUserGroupId();
        Long userPositionId = this.getCurUserPositionId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(userGroupId);
        user.setPositionId(userPositionId);
        user.setAccountId(userId);
        try {
            Long exampleId = example.getExampleId();
            if (exampleId == null) {
                example.setOcId(this.getCurOcId());
                example.setExampleId(actionVo.getWfInsId());
                example.setCreatedBy(userId);
                this.exampleService.createWfExample(example);
            } else {
                example.setOcId(ocId);
                example.setUpdatedBy(userId);
                this.exampleService.updateWfExample(example);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }
}

