/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.controller;

import com.zhyc.xps.bpm.dto.WfInsDto;
import com.zhyc.xps.bpm.service.WfInsService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wf/ins"})
public class WfInsController
extends BaseController {
    @Resource
    WfInsService wfInsService;

    @GetMapping(value={"/page"})
    public PageResult getWfInsByPage(@RequestParam Map<String, Object> map) {
        PageBean<WfInsDto> data = this.wfInsService.getWfInsByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getWfInsByList(@RequestParam Map<String, Object> map) {
        List<WfInsDto> data = this.wfInsService.getWfInsByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{ocId}/{wfInsId}"})
    public JsonResult getWfInsById(@PathVariable Long ocId, @PathVariable Long wfInsId) {
        WfInsDto data = this.wfInsService.getWfInsById(ocId, wfInsId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @DeleteMapping(value={"/{ocId}/{wfInsId}"})
    public JsonResult deleteWfInsById(@PathVariable Long ocId, @PathVariable Long wfInsId) {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("wfInsId", wfInsId);
            map.put("deletedBy", userId);
            this.wfInsService.deleteWfIns(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

