/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.bpm.dto.WfActivityInsDto;
import com.zhyc.xps.bpm.entity.WfActivityIns;
import com.zhyc.xps.bpm.mapper.WfActivityInsMapper;
import com.zhyc.xps.bpm.service.WfActivityInsService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WfActivityInsServiceImpl
extends BaseService
implements WfActivityInsService {
    @Resource
    WfActivityInsMapper wfActivityInsMapper;

    @Override
    public PageBean<WfActivityInsDto> getWfActivityInsByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<WfActivityInsDto> list = this.wfActivityInsMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public WfActivityInsDto getWfActivityInsById(Long ocId, Long wfInsId, Long activityInsId) {
        return this.wfActivityInsMapper.getById(ocId, wfInsId, activityInsId);
    }

    @Override
    public List<WfActivityInsDto> getWfActivityInsByList(Map<String, Object> map) {
        return this.wfActivityInsMapper.getByList(map);
    }

    @Override
    public void createWfActivityIns(WfActivityIns taskIns) throws Exception {
        taskIns.setActivityDefId(IdKit.getId());
        taskIns.setCreatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.create(taskIns);
    }

    @Override
    public void updateWfActivityIns(WfActivityIns taskIns) throws Exception {
        taskIns.setUpdatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.update(taskIns);
    }

    @Override
    public void deleteWfActivityIns(Map<String, Object> map) throws Exception {
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        this.wfActivityInsMapper.delete(map);
    }
}

