/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.bpm.dto.WfExampleInsDto;
import com.zhyc.xps.bpm.entity.WfExample;
import com.zhyc.xps.bpm.mapper.WfExampleMapper;
import com.zhyc.xps.bpm.service.WfExampleService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WfExampleServiceImpl
extends BaseService
implements WfExampleService {
    @Resource
    private WfExampleMapper exampleMapper;

    @Override
    public PageBean<WfExampleInsDto> getWfExampleByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<WfExampleInsDto> list = this.exampleMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public WfExampleInsDto getWfExampleById(Long ocId, Long exampleId) {
        return this.exampleMapper.getById(ocId, exampleId);
    }

    @Override
    public List<WfExampleInsDto> getWfExampleList(Map<String, Object> map) {
        return this.exampleMapper.getByList(map);
    }

    @Override
    public void createWfExample(WfExample wf) throws Exception {
        Long exampleId = wf.getExampleId();
        if (exampleId == null) {
            exampleId = IdKit.getId();
        }
        wf.setExampleId(exampleId);
        wf.setUpdatedAt(LocalDateTime.now());
        this.exampleMapper.create(wf);
    }

    @Override
    public void updateWfExample(WfExample wf) throws Exception {
        wf.setUpdatedAt(LocalDateTime.now());
        this.exampleMapper.update(wf);
    }

    @Override
    public void deleteWfExample(Map<String, Object> map) throws Exception {
        this.exampleMapper.delete(map);
    }

    @Override
    public void deleteWfExampleById(Long ocId, Long exampleId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("exampleId", exampleId);
        this.exampleMapper.delete(map);
    }
}

