/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.bpm.dto.WfInsDto;
import com.zhyc.xps.bpm.entity.WfIns;
import com.zhyc.xps.bpm.mapper.WfInsMapper;
import com.zhyc.xps.bpm.service.WfInsService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WfInsServiceImpl
extends BaseService
implements WfInsService {
    @Resource
    WfInsMapper wfInsMapper;

    @Override
    public PageBean<WfInsDto> getWfInsByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<WfInsDto> list = this.wfInsMapper.getByPage(map);
        return new PageBean(list);
    }

    @Override
    public WfInsDto getWfInsById(Long ocId, Long wfInsId) {
        return this.wfInsMapper.getById(ocId, wfInsId);
    }

    @Override
    public void createWfIns(WfIns ins) throws Exception {
        Long wfInsId = IdKit.getId();
        ins.setWfInsId(wfInsId);
        ins.setBeginTime(LocalDateTime.now());
        ins.setCreatedAt(LocalDateTime.now());
        this.wfInsMapper.create(ins);
    }

    @Override
    public void updateWfIns(WfIns ins) throws Exception {
        this.wfInsMapper.update(ins);
    }

    @Override
    public List<WfInsDto> getWfInsByList(Map<String, Object> map) {
        return this.wfInsMapper.getByList(map);
    }

    @Override
    public void deleteWfIns(Map<String, Object> map) throws Exception {
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        this.wfInsMapper.delete(map);
    }
}

