/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.bpm.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.bpm.dto.WfActivityActionDefDto;
import com.zhyc.xps.bpm.dto.WfActivityActionInsDto;
import com.zhyc.xps.bpm.dto.WfActivityDefDto;
import com.zhyc.xps.bpm.dto.WfActivityInsDto;
import com.zhyc.xps.bpm.dto.WfDefDto;
import com.zhyc.xps.bpm.dto.WfInsAttachDto;
import com.zhyc.xps.bpm.dto.WfInsDto;
import com.zhyc.xps.bpm.entity.WfActivityActionIns;
import com.zhyc.xps.bpm.entity.WfActivityIns;
import com.zhyc.xps.bpm.entity.WfIns;
import com.zhyc.xps.bpm.entity.WfInsAttach;
import com.zhyc.xps.bpm.mapper.WfActivityActionDefMapper;
import com.zhyc.xps.bpm.mapper.WfActivityActionInsMapper;
import com.zhyc.xps.bpm.mapper.WfActivityDefMapper;
import com.zhyc.xps.bpm.mapper.WfActivityInsMapper;
import com.zhyc.xps.bpm.mapper.WfDefMapper;
import com.zhyc.xps.bpm.mapper.WfInsAttachMapper;
import com.zhyc.xps.bpm.mapper.WfInsMapper;
import com.zhyc.xps.bpm.service.WfService;
import com.zhyc.xps.bpm.vo.WfActivityActionInsVo;
import com.zhyc.xps.bpm.vo.WfActivityInsRecordVo;
import com.zhyc.xps.bpm.vo.WfActivityInsVo;
import com.zhyc.xps.bpm.vo.WfInsVo;
import com.zhyc.xps.common.dto.AttachDto;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.vo.TaskUserVo;
import com.zhyc.xps.sys.constant.Glob;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class WfServiceImpl
extends BaseService
implements WfService {
    @Resource
    WfDefMapper wfDefMapper;
    @Resource
    WfActivityDefMapper wfActivityDefMapper;
    @Resource
    WfActivityActionDefMapper wfActivityActionDefMapper;
    @Resource
    WfInsMapper wfInsMapper;
    @Resource
    WfActivityInsMapper wfActivityInsMapper;
    @Resource
    WfActivityActionInsMapper wfActivityActionInsMapper;
    @Resource
    WfInsAttachMapper wfInsAttachMapper;

    @Override
    public WfInsVo createWfIns(TaskUserVo user, Long wfDefId) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        String groupName = user.getGroupName();
        Long positionId = user.getPositionId();
        String positionName = user.getPositionName();
        Long userId = user.getAccountId();
        String userName = user.getAccountName();
        Long wfInsId = IdKit.getId();
        WfDefDto wfDef = this.wfDefMapper.getById(wfDefId);
        if (ObjectUtils.isEmpty((Object)wfDef)) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728\uff01");
        }
        String wfDefTitle = wfDef.getWfDefTitle();
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfDefId(wfDefId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setWfInsTitle(wfDefTitle);
        wfIns.setStatus(Glob.WF_INS_STATUS_INI);
        wfIns.setBeginTime(LocalDateTime.now());
        wfIns.setCurGroupId(groupId);
        wfIns.setCurGroupName(groupName);
        wfIns.setCurPositionId(positionId);
        wfIns.setCurPositionName(positionName);
        wfIns.setCurAccountId(userId);
        wfIns.setCurAccountName(userName);
        wfIns.setCreatedBy(userId);
        wfIns.setCreatedAt(LocalDateTime.now());
        this.wfInsMapper.create(wfIns);
        Long taskDefId = Glob.WF_TASK_START;
        WfActivityDefDto taskDef = this.wfActivityDefMapper.getById(wfDefId, taskDefId);
        LocalDateTime startTime = LocalDateTime.now();
        WfActivityIns activityIns = new WfActivityIns();
        activityIns.setOcId(ocId);
        activityIns.setWfDefId(wfDefId);
        activityIns.setActivityDefId(taskDefId);
        activityIns.setWfInsId(wfInsId);
        activityIns.setActivityInsId(wfInsId);
        activityIns.setActivityInsTitle(taskDef.getActivityDefTitle());
        activityIns.setActivityCode(taskDef.getActivityCode());
        activityIns.setFormCode(taskDef.getFormCode());
        activityIns.setStartTime(startTime);
        activityIns.setStatus(Glob.WF_TASK_STATUS_0);
        activityIns.setGroupId(groupId);
        activityIns.setGroupName(groupName);
        activityIns.setPositionId(positionId);
        activityIns.setPositionName(positionName);
        activityIns.setAccountId(userId);
        activityIns.setAccountName(userName);
        activityIns.setCreatedAt(LocalDateTime.now());
        activityIns.setCreatedBy(userId);
        this.wfActivityInsMapper.create(activityIns);
        WfInsVo wfInsVo = new WfInsVo();
        wfInsVo.setWfInsId(wfIns.getWfInsId());
        wfInsVo.setWfDefId(wfIns.getWfDefId());
        wfInsVo.setWfInsTitle(wfIns.getWfInsTitle());
        wfInsVo.setStatus(wfIns.getStatus());
        wfInsVo.setCurActivityInsId(activityIns.getActivityInsId());
        wfInsVo.setCurActivityCode(activityIns.getActivityCode());
        wfInsVo.setCurActivityTitle(activityIns.getActivityInsTitle());
        wfInsVo.setCurFormCode(activityIns.getFormCode());
        wfInsVo.setCurActivityBeginTime(activityIns.getStartTime());
        wfInsVo.setCurGroupId(wfIns.getCurGroupId());
        wfInsVo.setCurGroupName(wfIns.getCurGroupName());
        wfInsVo.setCurPositionId(wfIns.getCurPositionId());
        wfInsVo.setCurPositionName(wfIns.getCurPositionName());
        wfInsVo.setCurAccountId(wfIns.getCurAccountId());
        wfInsVo.setCurAccountName(wfIns.getCurAccountName());
        WfActivityInsVo activityInsVo = new WfActivityInsVo();
        activityInsVo.setActivityDefId(taskDefId);
        activityInsVo.setActivityInsId(wfInsId);
        activityInsVo.setActivityInsTitle(taskDef.getActivityDefTitle());
        activityInsVo.setStatus(Glob.WF_TASK_STATUS_0);
        activityInsVo.setStartTime(startTime);
        activityInsVo.setActivityCode(taskDef.getActivityCode());
        activityInsVo.setFormCode(taskDef.getFormCode());
        List<WfActivityActionDefDto> actions = this.wfActivityActionDefMapper.getByList(wfDefId, taskDefId);
        activityInsVo.setActionList(actions);
        wfInsVo.setCurActivityIns(activityInsVo);
        return wfInsVo;
    }

    @Override
    public List<WfInsDto> getByList(Map<String, Object> map) {
        List<WfInsDto> wfInsDtolist = this.wfInsMapper.getByList(map);
        return wfInsDtolist;
    }

    @Override
    public PageBean<WfInsDto> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<WfInsDto> wfInsDtolist = this.wfInsMapper.getByPage(map);
        return new PageBean(wfInsDtolist);
    }

    @Override
    public WfInsVo getWfInsById(TaskUserVo user, Long wfInsId) {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        WfInsDto wfIns = this.wfInsMapper.getById(ocId, wfInsId);
        WfInsVo wfInsVo = new WfInsVo();
        wfInsVo.setWfDefId(wfIns.getWfDefId());
        wfInsVo.setWfInsId(wfInsId);
        wfInsVo.setWfInsTitle(wfIns.getWfInsTitle());
        wfInsVo.setStatus(wfIns.getStatus());
        wfInsVo.setBeginTime(wfIns.getBeginTime());
        wfInsVo.setFinishTime(wfIns.getFinishTime());
        wfInsVo.setCurActivityCode(wfIns.getCurActivityCode());
        wfInsVo.setCurActivityInsId(wfIns.getCurActivityInsId());
        wfInsVo.setCurActivityTitle(wfIns.getCurActivityTitle());
        wfInsVo.setCurFormCode(wfIns.getCurFormCode());
        wfInsVo.setCurGroupId(wfIns.getCurGroupId());
        wfInsVo.setCurGroupName(wfIns.getCurGroupName());
        wfInsVo.setCurPositionId(wfIns.getCurPositionId());
        wfInsVo.setCurPositionName(wfIns.getCurPositionName());
        wfInsVo.setCurAccountId(wfIns.getCurAccountId());
        wfInsVo.setCurAccountName(wfIns.getCurAccountName());
        WfActivityInsDto activityIns = this.wfActivityInsMapper.getCurActivityInsOfWf(ocId, wfInsId);
        if (activityIns != null) {
            WfActivityInsVo activityInsVo = new WfActivityInsVo();
            activityInsVo.setActivityDefId(activityIns.getActivityDefId());
            activityInsVo.setActivityInsId(activityIns.getActivityInsId());
            activityInsVo.setActivityInsTitle(activityIns.getActivityInsTitle());
            activityInsVo.setStatus(activityIns.getStatus());
            activityInsVo.setStartTime(activityIns.getStartTime());
            activityInsVo.setFormCode(activityIns.getFormCode());
            activityInsVo.setActivityCode(activityIns.getActivityCode());
            Long wfDefId = activityIns.getWfDefId();
            Long taskDefId = activityIns.getActivityDefId();
            Long taskUserId = activityIns.getAccountId();
            if (userId.equals(taskUserId)) {
                List<WfActivityActionDefDto> actions = this.wfActivityActionDefMapper.getByList(wfDefId, taskDefId);
                activityInsVo.setActionList(actions);
            }
            wfInsVo.setCurActivityIns(activityInsVo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("wfInsId", wfInsId);
        List<WfActivityActionInsDto> activityInsDtoList = this.wfActivityActionInsMapper.getByList(map);
        List<WfInsAttachDto> attachDtoList = this.wfInsAttachMapper.getByList(map);
        ArrayList<WfActivityInsRecordVo> recordList = new ArrayList<WfActivityInsRecordVo>();
        for (WfActivityActionInsDto dto : activityInsDtoList) {
            Long activityInsId = dto.getActivityInsId();
            WfActivityInsRecordVo record = new WfActivityInsRecordVo();
            record.setActivityInsId(activityInsId);
            record.setActivityInsTitle(dto.getActivityInsTitle());
            record.setGroupId(dto.getGroupId());
            record.setGroupName(dto.getGroupName());
            record.setPositionId(dto.getPositionId());
            record.setPositionName(dto.getPositionName());
            record.setAccountId(dto.getAccountId());
            record.setAccountName(dto.getAccountName());
            record.setFormCode(dto.getFormCode());
            record.setActionId(dto.getActionId());
            record.setActionCode(dto.getActionCode());
            record.setActionTitle(dto.getActionTitle());
            record.setActionResult(dto.getActionResult());
            record.setActionRemark(dto.getActionRemark());
            record.setActionTime(dto.getActionTime());
            ArrayList<WfInsAttachDto> fileList = new ArrayList<WfInsAttachDto>();
            for (WfInsAttachDto fileDto : attachDtoList) {
                Long tmpActivityInsId = fileDto.getActivityInsId();
                if (!activityInsId.equals(tmpActivityInsId)) continue;
                fileList.add(fileDto);
            }
            record.setAttachList(fileList);
            recordList.add(record);
        }
        wfInsVo.setActivityInsRecordList(recordList);
        return wfInsVo;
    }

    @Override
    public WfInsDto handleWfIns(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long wfInsId = action.getWfInsId();
        String actionCode = action.getActionCode();
        if ("transfer".equals(actionCode)) {
            this.handleTransfer(user, action);
        } else if ("cancel".equals(actionCode)) {
            this.handleCancel(user, action);
        } else if ("returnToHandler".equals(actionCode)) {
            this.handleReturnToHandler(user, action);
        } else if ("returnToActivity".equals(actionCode)) {
            this.handleReturnToActivity(user, action);
        } else if ("complete".equals(actionCode)) {
            this.handleComplete(user, action);
        } else {
            this.handleSubmit(user, action);
        }
        return this.wfInsMapper.getById(ocId, wfInsId);
    }

    private void handleSubmit(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        String activityCode = action.getActivityCode();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        if (ObjectUtils.isEmpty((Object)actionDef)) {
            throw new Exception("Action\u5b9a\u4e49\u9519\u8bef");
        }
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        Long nextActivityInsId = IdKit.getId();
        WfActivityIns wfActivityIns = new WfActivityIns();
        wfActivityIns.setOcId(ocId);
        wfActivityIns.setWfInsId(wfInsId);
        wfActivityIns.setActivityInsId(activityInsId);
        wfActivityIns.setEndTime(LocalDateTime.now());
        wfActivityIns.setStatus(Glob.WF_TASK_STATUS_1);
        wfActivityIns.setActivityInsTo(nextActivityInsId);
        wfActivityIns.setUpdatedAt(LocalDateTime.now());
        wfActivityIns.setUpdatedBy(userId);
        this.wfActivityInsMapper.update(wfActivityIns);
        this.handleAttach(user, action);
        Long groupIdTo = action.getGroupIdTo();
        Long positionIdTo = action.getPositionIdTo();
        Long accountIdTo = action.getAccountIdTo();
        String groupNameTo = action.getGroupNameTo();
        String positionNameTo = action.getPositionNameTo();
        String accountNameTo = action.getAccountNameTo();
        Long targetActivityDefId = actionDef.getTargetActivityDefId();
        WfActivityDefDto nextActivityDef = this.wfActivityDefMapper.getById(wfDefId, targetActivityDefId);
        if (ObjectUtils.isEmpty((Object)nextActivityDef)) {
            throw new Exception("Next Activity\u5b9a\u4e49\u9519\u8bef");
        }
        String nextActivityCode = nextActivityDef.getActivityCode();
        String nextActivityTitle = nextActivityDef.getActivityDefTitle();
        String nextFormCode = nextActivityDef.getFormCode();
        WfActivityIns nextActivityIns = new WfActivityIns();
        nextActivityIns.setOcId(ocId);
        nextActivityIns.setWfDefId(wfDefId);
        nextActivityIns.setWfInsId(wfInsId);
        nextActivityIns.setActivityDefId(targetActivityDefId);
        nextActivityIns.setActivityInsId(nextActivityInsId);
        nextActivityIns.setActivityInsTitle(nextActivityTitle);
        nextActivityIns.setStatus(Glob.WF_TASK_STATUS_0);
        nextActivityIns.setActivityCode(nextActivityCode);
        nextActivityIns.setFormCode(nextFormCode);
        nextActivityIns.setStartTime(LocalDateTime.now());
        nextActivityIns.setGroupId(groupIdTo);
        nextActivityIns.setPositionId(positionIdTo);
        nextActivityIns.setAccountId(accountIdTo);
        nextActivityIns.setGroupName(groupNameTo);
        nextActivityIns.setPositionName(positionNameTo);
        nextActivityIns.setAccountName(accountNameTo);
        nextActivityIns.setActivityInsFrom(activityInsId);
        nextActivityIns.setCreatedBy(userId);
        nextActivityIns.setCreatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.create(nextActivityIns);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setStatus(Glob.WF_INS_STATUS_HANDLING);
        wfIns.setWfInsId(wfInsId);
        wfIns.setWfDefId(wfDefId);
        wfIns.setCurActivityInsId(nextActivityInsId);
        wfIns.setCurActivityCode(nextActivityCode);
        wfIns.setCurActivityTitle(nextActivityTitle);
        wfIns.setCurFormCode(nextFormCode);
        wfIns.setCurGroupId(groupIdTo);
        wfIns.setCurPositionId(positionIdTo);
        wfIns.setCurAccountId(accountIdTo);
        wfIns.setCurGroupName(groupNameTo);
        wfIns.setCurPositionName(positionNameTo);
        wfIns.setCurAccountName(accountNameTo);
        wfIns.setCurActivityBeginTime(LocalDateTime.now());
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }

    private void handleTransfer(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        String activityCode = action.getActivityCode();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        if (ObjectUtils.isEmpty((Object)actionDef)) {
            throw new Exception("Action\u5b9a\u4e49\u9519\u8bef!");
        }
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        Long nextActivityInsId = IdKit.getId();
        WfActivityIns wfActivityIns = new WfActivityIns();
        wfActivityIns.setOcId(ocId);
        wfActivityIns.setWfInsId(wfInsId);
        wfActivityIns.setActivityInsId(activityInsId);
        wfActivityIns.setEndTime(LocalDateTime.now());
        wfActivityIns.setStatus(Glob.WF_TASK_STATUS_1);
        wfActivityIns.setActivityInsTo(nextActivityInsId);
        wfActivityIns.setUpdatedAt(LocalDateTime.now());
        wfActivityIns.setUpdatedBy(userId);
        this.wfActivityInsMapper.update(wfActivityIns);
        this.handleAttach(user, action);
        Long groupIdTo = action.getGroupIdTo();
        Long positionIdTo = action.getPositionIdTo();
        Long accountIdTo = action.getAccountIdTo();
        String groupNameTo = action.getGroupNameTo();
        String positionNameTo = action.getPositionNameTo();
        String accountNameTo = action.getAccountNameTo();
        WfActivityInsDto activityInsDto = this.wfActivityInsMapper.getById(ocId, wfInsId, activityInsId);
        if (ObjectUtils.isEmpty((Object)activityInsDto)) {
            throw new Exception("Activity\u5b9e\u4f8b\u9519\u8bef!");
        }
        String nextActivityCode = activityInsDto.getActivityCode();
        String nextActivityTitle = activityInsDto.getActivityInsTitle();
        String nextFormCode = activityInsDto.getFormCode();
        WfActivityIns nextActivityIns = new WfActivityIns();
        nextActivityIns.setOcId(ocId);
        nextActivityIns.setWfDefId(wfDefId);
        nextActivityIns.setWfInsId(wfInsId);
        nextActivityIns.setActivityDefId(activityDefId);
        nextActivityIns.setActivityInsId(nextActivityInsId);
        nextActivityIns.setActivityInsTitle(nextActivityTitle);
        nextActivityIns.setStatus(Glob.WF_TASK_STATUS_0);
        nextActivityIns.setActivityCode(nextActivityCode);
        nextActivityIns.setFormCode(nextFormCode);
        nextActivityIns.setStartTime(LocalDateTime.now());
        nextActivityIns.setGroupId(groupIdTo);
        nextActivityIns.setPositionId(positionIdTo);
        nextActivityIns.setAccountId(accountIdTo);
        nextActivityIns.setGroupName(groupNameTo);
        nextActivityIns.setPositionName(positionNameTo);
        nextActivityIns.setAccountName(accountNameTo);
        nextActivityIns.setActivityInsFrom(activityInsId);
        nextActivityIns.setCreatedBy(userId);
        nextActivityIns.setCreatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.create(nextActivityIns);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setWfDefId(wfDefId);
        wfIns.setCurActivityInsId(activityInsId);
        wfIns.setCurFormCode(nextFormCode);
        wfIns.setCurGroupId(groupIdTo);
        wfIns.setCurPositionId(positionIdTo);
        wfIns.setCurAccountId(accountIdTo);
        wfIns.setCurGroupName(groupNameTo);
        wfIns.setCurPositionName(positionNameTo);
        wfIns.setCurAccountName(accountNameTo);
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }

    private void handleCancel(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        if (ObjectUtils.isEmpty((Object)actionDef)) {
            throw new Exception("Action\u5b9a\u4e49\u9519\u8bef!");
        }
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        this.handleAttach(user, action);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setStatus(Glob.WF_INS_STATUS_CANCELED);
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        wfIns.setCurActivityInsId(0L);
        wfIns.setCurAccountId(0L);
        wfIns.setCurPositionId(0L);
        wfIns.setCurGroupId(0L);
        wfIns.setCurGroupName("");
        wfIns.setCurPositionName("");
        wfIns.setCurAccountName("");
        wfIns.setCurActivityCode("-");
        wfIns.setCurActivityTitle("-");
        wfIns.setCurFormCode("-");
        wfIns.setFinishTime(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        wfIns.setUpdatedAt(LocalDateTime.now());
        this.wfInsMapper.update(wfIns);
    }

    private void handleReturnToHandler(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        String activityCode = action.getActivityCode();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        WfActivityActionInsDto returnActivityIns = this.wfActivityActionInsMapper.getPreHandlerOfWf(ocId, wfInsId);
        String nextActivityCode = returnActivityIns.getActivityCode();
        String nextActivityTitle = returnActivityIns.getActivityInsTitle();
        String nextFormCode = returnActivityIns.getFormCode();
        Long nextActivityDefId = returnActivityIns.getActivityDefId();
        Long groupIdTo = returnActivityIns.getGroupId();
        Long positionIdTo = returnActivityIns.getPositionId();
        Long accountIdTo = returnActivityIns.getAccountId();
        String groupNameTo = returnActivityIns.getGroupName();
        String positionNameTo = returnActivityIns.getPositionName();
        String accountNameTo = returnActivityIns.getAccountName();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        Long nextActivityInsId = IdKit.getId();
        WfActivityIns wfActivityIns = new WfActivityIns();
        wfActivityIns.setOcId(ocId);
        wfActivityIns.setWfInsId(wfInsId);
        wfActivityIns.setActivityInsId(activityInsId);
        wfActivityIns.setEndTime(LocalDateTime.now());
        wfActivityIns.setStatus(Glob.WF_TASK_STATUS_1);
        wfActivityIns.setActivityInsTo(nextActivityInsId);
        wfActivityIns.setUpdatedAt(LocalDateTime.now());
        wfActivityIns.setUpdatedBy(userId);
        this.wfActivityInsMapper.update(wfActivityIns);
        this.handleAttach(user, action);
        WfActivityIns nextActivityIns = new WfActivityIns();
        nextActivityIns.setOcId(ocId);
        nextActivityIns.setWfDefId(wfDefId);
        nextActivityIns.setWfInsId(wfInsId);
        nextActivityIns.setActivityDefId(nextActivityDefId);
        nextActivityIns.setActivityInsId(nextActivityInsId);
        nextActivityIns.setActivityInsTitle(nextActivityTitle);
        nextActivityIns.setStatus(Glob.WF_TASK_STATUS_0);
        nextActivityIns.setActivityCode(nextActivityCode);
        nextActivityIns.setFormCode(nextFormCode);
        nextActivityIns.setStartTime(LocalDateTime.now());
        nextActivityIns.setGroupId(groupIdTo);
        nextActivityIns.setPositionId(positionIdTo);
        nextActivityIns.setAccountId(accountIdTo);
        nextActivityIns.setGroupName(groupNameTo);
        nextActivityIns.setPositionName(positionNameTo);
        nextActivityIns.setAccountName(accountNameTo);
        nextActivityIns.setActivityInsFrom(activityInsId);
        nextActivityIns.setCreatedBy(userId);
        nextActivityIns.setCreatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.create(nextActivityIns);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setWfDefId(wfDefId);
        wfIns.setCurActivityInsId(nextActivityInsId);
        wfIns.setCurActivityCode(nextActivityCode);
        wfIns.setCurActivityTitle(nextActivityTitle);
        wfIns.setCurFormCode(nextFormCode);
        wfIns.setCurGroupId(groupIdTo);
        wfIns.setCurPositionId(positionIdTo);
        wfIns.setCurAccountId(accountIdTo);
        wfIns.setCurGroupName(groupNameTo);
        wfIns.setCurPositionName(positionNameTo);
        wfIns.setCurAccountName(accountNameTo);
        wfIns.setCurActivityBeginTime(LocalDateTime.now());
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }

    private void handleReturnToActivity(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        String activityCode = action.getActivityCode();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        Long nextActivityInsId = IdKit.getId();
        WfActivityIns wfActivityIns = new WfActivityIns();
        wfActivityIns.setOcId(ocId);
        wfActivityIns.setWfInsId(wfInsId);
        wfActivityIns.setActivityInsId(activityInsId);
        wfActivityIns.setEndTime(LocalDateTime.now());
        wfActivityIns.setStatus(Glob.WF_TASK_STATUS_1);
        wfActivityIns.setActivityInsTo(nextActivityInsId);
        wfActivityIns.setUpdatedAt(LocalDateTime.now());
        wfActivityIns.setUpdatedBy(userId);
        this.wfActivityInsMapper.update(wfActivityIns);
        this.handleAttach(user, action);
        WfActivityInsDto returnActivityIns = this.wfActivityInsMapper.getPreActivityInsOfWf(ocId, wfInsId, wfDefId);
        String nextActivityCode = returnActivityIns.getActivityCode();
        String nextActivityTitle = returnActivityIns.getActivityInsTitle();
        String nextFormCode = returnActivityIns.getFormCode();
        Long nextActivityDefId = returnActivityIns.getActivityDefId();
        Long groupIdTo = returnActivityIns.getGroupId();
        Long positionIdTo = returnActivityIns.getPositionId();
        Long accountIdTo = returnActivityIns.getAccountId();
        String groupNameTo = returnActivityIns.getGroupName();
        String positionNameTo = returnActivityIns.getPositionName();
        String accountNameTo = returnActivityIns.getAccountName();
        WfActivityIns nextActivityIns = new WfActivityIns();
        nextActivityIns.setOcId(ocId);
        nextActivityIns.setWfDefId(wfDefId);
        nextActivityIns.setWfInsId(wfInsId);
        nextActivityIns.setActivityDefId(nextActivityDefId);
        nextActivityIns.setActivityInsId(nextActivityInsId);
        nextActivityIns.setActivityInsTitle(nextActivityTitle);
        nextActivityIns.setStatus(Glob.WF_TASK_STATUS_0);
        nextActivityIns.setActivityCode(nextActivityCode);
        nextActivityIns.setFormCode(nextFormCode);
        nextActivityIns.setStartTime(LocalDateTime.now());
        nextActivityIns.setGroupId(groupIdTo);
        nextActivityIns.setPositionId(positionIdTo);
        nextActivityIns.setAccountId(accountIdTo);
        nextActivityIns.setGroupName(groupNameTo);
        nextActivityIns.setPositionName(positionNameTo);
        nextActivityIns.setAccountName(accountNameTo);
        nextActivityIns.setActivityInsFrom(activityInsId);
        nextActivityIns.setCreatedBy(userId);
        nextActivityIns.setCreatedAt(LocalDateTime.now());
        this.wfActivityInsMapper.create(nextActivityIns);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setWfDefId(wfDefId);
        wfIns.setCurActivityInsId(nextActivityInsId);
        wfIns.setCurActivityCode(nextActivityCode);
        wfIns.setCurActivityTitle(nextActivityTitle);
        wfIns.setCurFormCode(nextFormCode);
        wfIns.setCurGroupId(groupIdTo);
        wfIns.setCurPositionId(positionIdTo);
        wfIns.setCurAccountId(accountIdTo);
        wfIns.setCurGroupName(groupNameTo);
        wfIns.setCurPositionName(positionNameTo);
        wfIns.setCurAccountName(accountNameTo);
        wfIns.setCurActivityBeginTime(LocalDateTime.now());
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }

    private void handleComplete(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        Long userId = user.getAccountId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfDefId = action.getWfDefId();
        Long wfInsId = action.getWfInsId();
        Long activityDefId = action.getActivityDefId();
        Long activityInsId = action.getActivityInsId();
        Long actionId = action.getActionId();
        String actionCode = action.getActionCode();
        Long actionInsId = IdKit.getId();
        WfActivityActionDefDto actionDef = this.wfActivityActionDefMapper.getById(wfDefId, activityDefId, actionId);
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle(actionDef.getActionTitle());
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode(actionDef.getFormCode());
        wfActivityActionIns.setActionResult(action.getActionResult());
        wfActivityActionIns.setActionRemark(action.getActionRemark());
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setTargetActivityInsId(actionDef.getTargetActivityDefId());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        WfActivityIns wfActivityIns = new WfActivityIns();
        wfActivityIns.setOcId(ocId);
        wfActivityIns.setWfInsId(wfInsId);
        wfActivityIns.setActivityInsId(activityInsId);
        wfActivityIns.setEndTime(LocalDateTime.now());
        wfActivityIns.setStatus(Glob.WF_TASK_STATUS_1);
        wfActivityIns.setUpdatedAt(LocalDateTime.now());
        wfActivityIns.setUpdatedBy(userId);
        this.wfActivityInsMapper.update(wfActivityIns);
        this.handleAttach(user, action);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setStatus(Glob.WF_INS_STATUS_COMPLETED);
        wfIns.setCurActivityTitle("");
        wfIns.setCurActivityInsId(0L);
        wfIns.setCurActivityCode("-");
        wfIns.setCurFormCode("-");
        wfIns.setCurActivityBeginTime(null);
        wfIns.setCurGroupId(0L);
        wfIns.setCurPositionId(0L);
        wfIns.setCurAccountId(0L);
        wfIns.setCurGroupName("");
        wfIns.setCurPositionName("");
        wfIns.setCurAccountName("");
        wfIns.setFinishTime(LocalDateTime.now());
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }

    private void handleAttach(TaskUserVo user, WfActivityActionInsVo action) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        Long wfInsId = action.getWfInsId();
        Long activityInsId = action.getActivityInsId();
        String activityCode = action.getActivityCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("wfInsId", wfInsId);
        map.put("activityInsId", activityInsId);
        this.wfInsAttachMapper.delete(map);
        List<AttachDto> attachList = action.getAttachList();
        if (attachList != null) {
            for (AttachDto attachDto : attachList) {
                this.attachFileAction(ocId, userId, wfInsId, activityInsId, activityCode, attachDto);
            }
        }
    }

    private void attachFileAction(Long ocId, Long userId, Long wfInsId, Long activityInsId, String activityCode, AttachDto attachDto) throws Exception {
        Long fileId = attachDto.getFileId();
        WfInsAttach activityAttach = new WfInsAttach();
        activityAttach.setOcId(ocId);
        activityAttach.setWfInsId(wfInsId);
        activityAttach.setActivityInsId(activityInsId);
        activityAttach.setActivityCode(activityCode);
        activityAttach.setFileId(fileId);
        activityAttach.setCreatedBy(userId);
        activityAttach.setCreatedAt(LocalDateTime.now());
        this.wfInsAttachMapper.create(activityAttach);
    }

    @Override
    public void cancelWfIns(TaskUserVo user, Long wfInsId) throws Exception {
        Long ocId = user.getOcId();
        Long userId = user.getAccountId();
        Long groupId = user.getGroupId();
        Long positionId = user.getPositionId();
        String groupName = user.getGroupName();
        String positionName = user.getPositionName();
        String accountName = user.getAccountName();
        WfActivityInsDto activityIns = this.wfActivityInsMapper.getCurActivityInsOfWf(ocId, wfInsId);
        if (!ObjectUtils.isEmpty((Object)activityIns)) {
            throw new Exception("\u6d41\u7a0b\u5df2\u5904\u7406\u5b8c\u6bd5");
        }
        Long wfDefId = activityIns.getWfDefId();
        Long activityDefId = activityIns.getActivityDefId();
        Long activityInsId = activityIns.getActivityInsId();
        Long actionId = Glob.WF_ACTIVITY_ACTION_CANCEL;
        Long actionInsId = IdKit.getId();
        String actionCode = "cancel";
        WfActivityActionIns wfActivityActionIns = new WfActivityActionIns();
        wfActivityActionIns.setOcId(ocId);
        wfActivityActionIns.setWfDefId(wfDefId);
        wfActivityActionIns.setWfInsId(wfInsId);
        wfActivityActionIns.setActivityDefId(activityDefId);
        wfActivityActionIns.setActivityInsId(activityInsId);
        wfActivityActionIns.setActionInsId(actionInsId);
        wfActivityActionIns.setActionId(actionId);
        wfActivityActionIns.setActionTitle("\u64a4\u6d88");
        wfActivityActionIns.setActionCode(actionCode);
        wfActivityActionIns.setFormCode("-");
        wfActivityActionIns.setActionResult("");
        wfActivityActionIns.setActionRemark("\u64a4\u6d88\u4efb\u52a1");
        wfActivityActionIns.setActionTime(LocalDateTime.now());
        wfActivityActionIns.setGroupId(groupId);
        wfActivityActionIns.setPositionId(positionId);
        wfActivityActionIns.setAccountId(userId);
        wfActivityActionIns.setGroupName(groupName);
        wfActivityActionIns.setPositionName(positionName);
        wfActivityActionIns.setAccountName(accountName);
        wfActivityActionIns.setCreatedAt(LocalDateTime.now());
        wfActivityActionIns.setCreatedBy(userId);
        this.wfActivityActionInsMapper.create(wfActivityActionIns);
        WfIns wfIns = new WfIns();
        wfIns.setOcId(ocId);
        wfIns.setWfInsId(wfInsId);
        wfIns.setStatus(Glob.WF_INS_STATUS_CANCELED);
        wfIns.setFinishTime(LocalDateTime.now());
        wfIns.setUpdatedAt(LocalDateTime.now());
        wfIns.setUpdatedBy(userId);
        this.wfInsMapper.update(wfIns);
    }
}

