/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.controller;

import com.zhyc.xps.common.cache.CacheManager;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.dto.UserDto;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.enums.ResultEnum;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected HttpServletRequest request;
    @Resource
    CacheManager cacheManager;

    public String getStrPara(String paraName) {
        return this.request.getParameter(paraName);
    }

    public String getStrAttr(String name) {
        return (String)this.request.getAttribute(name);
    }

    public Long getLongPara(String paraName) {
        String szPara = this.request.getParameter(paraName);
        return Long.valueOf(szPara);
    }

    public Long getLongAttr(String name) {
        return (Long)this.request.getAttribute(name);
    }

    public PageResult pageResult(PageBean<?> pageData) {
        return this.showPageResult(0, pageData);
    }

    public PageResult showPageResult(Integer code, PageBean<?> pageInfo) {
        PageResult result = new PageResult();
        if (pageInfo != null) {
            result.setTotal(pageInfo.getTotalCount());
            result.setData(pageInfo.getList());
            result.setPage(pageInfo.getPageNum());
            result.setLimit(pageInfo.getPageSize());
        } else {
            result.setTotal(0L);
            result.setPage(0L);
            result.setLimit(0L);
        }
        result.setCode(code);
        return result;
    }

    public PageResult pageResult(List<?> pageInfo) {
        PageResult result = new PageResult();
        result.setTotal(pageInfo.size());
        result.setData(pageInfo);
        return result;
    }

    public PageResult pageResult(List<?> pageInfo, long count) {
        PageResult result = new PageResult();
        result.setTotal(count);
        result.setData(pageInfo);
        return result;
    }

    public JsonResult jsonResult(boolean bRet, String msg, Object data) {
        if (bRet) {
            return ResultEnum.me.showJsonResult(0, msg, data);
        }
        return ResultEnum.me.showJsonResult(500, msg, data);
    }

    public JsonResult resultOk(String msg) {
        return ResultEnum.me.showJsonResult(0, msg, null);
    }

    public JsonResult resultOk(String msg, Object data) {
        return ResultEnum.me.showJsonResult(0, msg, data);
    }

    public JsonResult resultErr(String msg, Object data) {
        return ResultEnum.me.showJsonResult(500, msg, data);
    }

    public JsonResult resultErr(String msg) {
        return ResultEnum.me.showJsonResult(500, msg, null);
    }

    public String getCurUserName() {
        return this.getStrAttr("userName");
    }

    public Long getCurUserId() {
        return this.getLongAttr("userId");
    }

    public UserDto getCurUser() {
        Long userId = this.getCurUserId();
        return this.cacheManager.getUser(userId);
    }

    public Long getCurUserRoleId() {
        return this.getCurUser().getRoleId();
    }

    public Long getCurUserRoleTypeId() {
        return this.getCurUser().getRoleTypeId();
    }

    public Long getCurOcId() {
        return this.getCurUser().getOcId();
    }

    public Long getCurOcTypeId() {
        return this.getCurUser().getOcTypeId();
    }

    public String getCurOcName() {
        return this.getCurUser().getOcName();
    }

    public Long getCurOcAdminId() {
        return this.getCurUser().getOcAdminId();
    }

    public Long getCurOcGroupId() {
        return this.getCurUser().getOcGroupId();
    }

    public Long getCurUserGroupId() {
        return this.getCurUser().getGroupId();
    }

    public String getCurUserGroupName() {
        return this.getCurUser().getGroupName();
    }

    public Long getCurUserPositionId() {
        return this.getCurUser().getPositionId();
    }

    public String getCurUserPositionName() {
        return this.getCurUser().getPositionName();
    }
}

