/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.entity;

import com.github.pagehelper.Page;
import com.zhyc.xps.common.utils.Constant;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageBean<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PageBean.class);
    private static final long serialVersionUID = 8656597559014685635L;
    private long totalCount;
    private List<T> list;
    private int pageNum;
    private int pageSize;
    private int totalPage;
    private int currentSize;

    public PageBean(List<T> list) {
        if (list instanceof Page) {
            Page page = (Page)list;
            this.pageNum = page.getPageNum();
            this.pageSize = page.getPageSize();
            this.totalCount = page.getTotal();
            this.totalPage = page.getPages();
            this.list = page;
            this.currentSize = page.size();
        } else {
            this.pageNum = Constant.DEFAULT_PAGE_NUMBER;
            this.pageSize = Constant.DEFAULT_PAGE_SIZE;
            this.list = list;
            this.totalCount = list.size();
        }
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public List<T> getList() {
        return this.list;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setCurrentSize(int currentSize) {
        this.currentSize = currentSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBean)) {
            return false;
        }
        PageBean other = (PageBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getPageNum() != other.getPageNum()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getCurrentSize() != other.getCurrentSize()) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        result = result * 59 + this.getPageNum();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalPage();
        result = result * 59 + this.getCurrentSize();
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "PageBean(totalCount=" + this.getTotalCount() + ", list=" + this.getList() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", totalPage=" + this.getTotalPage() + ", currentSize=" + this.getCurrentSize() + ")";
    }
}

