/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.service;

import com.google.common.collect.Lists;
import com.zhyc.xps.common.entity.FileBean;
import com.zhyc.xps.common.fdfd.FastdfsClientUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FastDfsService {
    private static final Logger log = LoggerFactory.getLogger(FastDfsService.class);
    @Value(value="${base_img_http}")
    private String baseImgHttp;
    @Resource
    private FastdfsClientUtil fastdfsClientUtil;

    public FileBean saveFile(MultipartFile uploadFile) {
        String originalFileName = uploadFile.getOriginalFilename();
        if (originalFileName.isEmpty()) {
            return null;
        }
        String extName = originalFileName.substring(originalFileName.lastIndexOf(46) + 1);
        long fileSize = uploadFile.getSize();
        FileBean fileBean = new FileBean();
        fileBean.setExt(extName);
        fileBean.setOriFileName(originalFileName);
        fileBean.setMimeType(uploadFile.getContentType());
        fileBean.setSize(fileSize);
        try {
            fileBean = this.fastdfsClientUtil.upload(uploadFile, fileBean);
            String[] path = fileBean.getPath().split("\\$");
            int two = 2;
            if (path.length == two) {
                fileBean.setPath(this.baseImgHttp.concat(path[0]).concat("$").concat(this.baseImgHttp.concat(path[1])));
            } else {
                fileBean.setPath(this.baseImgHttp + fileBean.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("###" + originalFileName);
        System.out.println("###" + extName);
        System.out.println("###" + fileBean.getPath());
        System.out.println("###" + fileSize);
        return fileBean;
    }

    public FileBean saveFile2(MultipartFile uploadFile) {
        String originalFileName = uploadFile.getOriginalFilename();
        if (originalFileName.isEmpty()) {
            return null;
        }
        String extName = originalFileName.substring(originalFileName.lastIndexOf(46) + 1);
        long fileSize = uploadFile.getSize();
        FileBean fileBean = new FileBean();
        fileBean.setExt(extName);
        fileBean.setOriFileName(originalFileName);
        fileBean.setMimeType(uploadFile.getContentType());
        fileBean.setSize(fileSize);
        try {
            fileBean = this.fastdfsClientUtil.upload(uploadFile, fileBean);
            fileBean.setPath(this.baseImgHttp + fileBean.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("###origin:" + originalFileName);
        System.out.println("###ext:" + extName);
        System.out.println("###path:" + fileBean.getPath());
        System.out.println("###size:" + fileSize);
        return fileBean;
    }

    public List<String> saveImages(MultipartFile[] files) {
        ArrayList list = Lists.newArrayList();
        try {
            for (MultipartFile uploadFile : files) {
                if (uploadFile.isEmpty()) continue;
                list.add(this.baseImgHttp + this.fastdfsClientUtil.upload(uploadFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<FileBean> saveFiles(MultipartFile[] files) {
        ArrayList list = Lists.newArrayList();
        try {
            for (MultipartFile uploadFile : files) {
                FileBean bean;
                if (uploadFile.isEmpty() || ObjectUtils.isEmpty((Object)(bean = this.saveFile2(uploadFile)))) continue;
                list.add(bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public FileBean saveByteFile(byte[] bytes, String prefix) {
        FileBean fileBean = new FileBean();
        try {
            fileBean.setPath(this.baseImgHttp + this.fastdfsClientUtil.upload(bytes, prefix));
            fileBean.setExt(prefix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileBean;
    }
}

