/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.service;

import cn.hutool.core.date.DateUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWatermarkUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageWatermarkUtil.class);
    private static final String MARK_TEXT = "\u667a\u6167\u5b89\u5168\u7ba1\u63a7\u9884\u8b66\u5e73\u53f0";
    private static final String FONT_NAME = "\u5fae\u8f6f\u96c5\u9ed1";
    private static final int FONT_STYLE = 1;
    private static final int FONT_SIZE = 20;
    private static final Color FONT_COLOR = Color.gray;
    private static final String PATH = "/Users/mac/Desktop/dzghv2/t/";
    private static final float ALPHA = 0.3f;

    public static String moreTextWaterMark(String myFile, String imageFileName) {
        ImageWatermarkUtil.moreTextWaterMark(PATH, myFile, imageFileName, MARK_TEXT);
        return "success";
    }

    public static String moreTextWaterMark(String basePath, String sourcePath, String outputPath, String markText) {
        InputStream is = null;
        OutputStream os = null;
        int X = 636;
        int Y = 763;
        File logossss = new File(sourcePath);
        try {
            BufferedImage image = ImageIO.read(logossss);
            int width = ((Image)image).getWidth(null);
            int height = ((Image)image).getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D graphics2d = bufferedImage.createGraphics();
            graphics2d.drawImage(image, 0, 0, width, height, null);
            graphics2d.setFont(new Font(FONT_NAME, 1, 20));
            graphics2d.setColor(FONT_COLOR);
            int waterWidth = 20 * ImageWatermarkUtil.getTextLength(markText);
            int waterHeight = 20;
            graphics2d.setComposite(AlphaComposite.getInstance(10, 0.3f));
            graphics2d.rotate(Math.toRadians(30.0), bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
            int x = -width / 2;
            int y = -height / 2;
            while ((double)x < (double)width * 1.5) {
                y = -height / 2;
                while ((double)y < (double)height * 1.5) {
                    graphics2d.drawString(markText, x, y);
                    y += waterHeight + 100;
                }
                x += waterWidth + 100;
            }
            graphics2d.dispose();
            String dstName = basePath + "/" + outputPath;
            String formatName = dstName.substring(dstName.lastIndexOf(".") + 1);
            ImageIO.write((RenderedImage)bufferedImage, formatName, new File(dstName));
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "success";
    }

    public static int getTextLength(String text) {
        int length = text.length();
        for (int i = 0; i < text.length(); ++i) {
            String s = String.valueOf(text.charAt(i));
            if (s.getBytes().length <= 1) continue;
            ++length;
        }
        length = length % 2 == 0 ? length / 2 : length / 2 + 1;
        return length;
    }

    public static void waterPress(String srcImgPath, String outImgPath, Color markContentColor, int fontSize, String waterMarkContent) {
        try {
            String[] waterMarkContents = waterMarkContent.split("\\|\\|");
            File srcImgFile = new File(srcImgPath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            Font font = new Font("\u5b8b\u4f53", 0, fontSize);
            g.setColor(markContentColor);
            g.setFont(font);
            int contentLength = waterMarkContents.length;
            int maxLength = 0;
            for (int i = 0; i < contentLength; ++i) {
                int fontlen = ImageWatermarkUtil.getWatermarkLength(waterMarkContents[i], g);
                if (maxLength >= fontlen) continue;
                maxLength = fontlen;
            }
            for (int j = 0; j < contentLength; ++j) {
                waterMarkContent = waterMarkContents[j];
                int tempX = 10;
                int tempY = fontSize;
                int tempCharLen = 0;
                int tempLineLen = 0;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < waterMarkContent.length(); ++i) {
                    char tempChar = waterMarkContent.charAt(i);
                    tempCharLen = ImageWatermarkUtil.getCharLen(tempChar, g);
                    if ((tempLineLen += tempCharLen) >= srcImgWidth) {
                        g.drawString(sb.toString(), tempX, tempY);
                        sb.delete(0, sb.length());
                        tempLineLen = 0;
                    }
                    sb.append(tempChar);
                }
                g.drawString(sb.toString(), srcImgWidth - maxLength, srcImgHeight - (contentLength - j - 1) * tempY - 30);
            }
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(outImgPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getCharLen(char c, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charWidth(c);
    }

    public static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }

    public static void main1(String[] args) {
        File file = new File(PATH);
        File[] tempList = file.listFiles();
        for (int i = 0; i < tempList.length; ++i) {
            String fileFullName;
            String fileName;
            if (tempList[i].isFile() && !(fileName = (fileFullName = tempList[i].getName()).substring(0, fileFullName.lastIndexOf("."))).equals("")) {
                String prefix = fileFullName.substring(fileFullName.lastIndexOf(".") + 1);
                String newFileName = fileName + "_1." + prefix;
                System.out.println(fileFullName);
                System.out.println(newFileName);
                ImageWatermarkUtil.moreTextWaterMark(PATH, tempList[i].toString(), newFileName, "\u6211\u6765\u6d4b\u8bd5");
            }
            if (!tempList[i].isDirectory()) continue;
        }
        System.out.println("\u6210\u529f");
    }

    public static void main2(String[] args) {
        String font = "\u9655\u897f\u7701||".concat(DateUtil.now());
        String inputAddress = "/Users/mac/Desktop/dzghv2/t/sc.jpg";
        String outputAddress = "/Users/mac/Desktop/dzghv2/t/sc_.jpg";
        Color color = Color.GREEN;
        ImageWatermarkUtil.waterPress(inputAddress, outputAddress, color, 50, font);
        ImageWatermarkUtil.moreTextWaterMark("", outputAddress, outputAddress, "\u9655\u897f\u7701");
    }

    public static void main(String[] args) {
        ImageWatermarkUtil.main2(null);
    }
}

