/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.service;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.zhyc.xps.common.utils.RedisUtils;
import com.zhyc.xps.common.utils.StringUtils;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QywxService {
    private static final Logger log = LoggerFactory.getLogger(QywxService.class);
    @Value(value="${corpid}")
    private String corpid;
    @Value(value="${corpsecret}")
    private String corpsecret;
    @Value(value="${appid}")
    private String appid;
    @Resource
    RedisUtils redisUtils;

    public String gettoken() {
        String accessTokenS = (String)this.redisUtils.get("access_token");
        if (StringUtils.isEmpty(accessTokenS)) {
            String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + this.corpid + "&corpsecret=" + this.corpsecret;
            String result = HttpUtil.get((String)url, (int)3000);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (Integer.parseInt(jsonObject.get("errcode").toString()) == 0) {
                String access_token = jsonObject.get("access_token").toString();
                jsonObject.get("expires_in");
                jsonObject.get("errmsg");
                log.info("gettoken", (Object)result);
                this.redisUtils.set("access_token", access_token, Long.parseLong(jsonObject.get("expires_in").toString()));
                return jsonObject.get("access_token").toString();
            }
            log.info("gettoken \u8bf7\u6c42\u5931\u8d25\uff01", (Object)result);
            return null;
        }
        return accessTokenS;
    }

    public String jscode2session(String code) {
        String accessToken = this.gettoken();
        if (StringUtils.isNotEmpty(accessToken) && StringUtils.isNotEmpty(code)) {
            String url = "https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session?access_token=" + accessToken + "&js_code=" + code + "&grant_type=authorization_code";
            String result = HttpUtil.get((String)url, (int)3000);
            JSONObject jsonObject = JSON.parseObject((String)result);
            String errmsg = null;
            if (Integer.parseInt(jsonObject.get("errcode").toString()) == 0) {
                String userid = jsonObject.get("userid").toString();
                String corpid = jsonObject.get("corpid").toString();
                String session_key = jsonObject.get("session_key").toString();
                errmsg = jsonObject.get("errmsg").toString();
                log.info("jscode2session %s", (Object)result);
                return userid;
            }
            log.info("jscode2session \u8bf7\u6c42\u5931\u8d25\uff01 %s", (Object)result);
            return errmsg;
        }
        log.info("jscode2session \u8bf7\u6c42\u5931\u8d25\uff01 %s  %s", (Object)accessToken, (Object)code);
        return "\u53c2\u6570\u662f\u7a7a\u7684accessToken->" + accessToken + "code--->" + code;
    }

    public String sendEnterpriseWeChatMessages(String paramMap) {
        String accessToken = this.gettoken();
        if (StringUtils.isNotEmpty(accessToken)) {
            String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken;
            String result = HttpUtil.post((String)url, (String)paramMap, (int)3000);
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (Integer.parseInt(jsonObject.get("errcode").toString()) != 0) {
                log.info("sendEnterpriseWeChatMessages \u53d1\u9001\u5931\u8d25\uff01" + result);
                return "fail";
            }
            log.info("sendEnterpriseWeChatMessages-->" + result);
            return "success";
        }
        log.info("sendEnterpriseWeChatMessages \u8bf7\u6c42\u5931\u8d25\uff01-->" + accessToken);
        return "sendEnterpriseWeChatMessages\u53c2\u6570\u662f\u7a7a\u7684,accessToken->" + accessToken;
    }

    public String sendWeChatMessages(String page, String title, String description, String touser, String key1, String value1, String key2, String value2, String key3, String value3, String key4, String value4) {
        JSONArray array = new JSONArray();
        if (StringUtils.isNotEmpty(key1)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"key", (Object)key1);
            jsonObject.put((Object)"value", (Object)value1);
            array.add((Object)jsonObject);
        }
        if (StringUtils.isNotEmpty(key2)) {
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put((Object)"key", (Object)key2);
            jsonObject2.put((Object)"value", (Object)value2);
            array.add((Object)jsonObject2);
        }
        if (StringUtils.isNotEmpty(key3)) {
            JSONObject jsonObject3 = new JSONObject();
            jsonObject3.put((Object)"key", (Object)key3);
            jsonObject3.put((Object)"value", (Object)value3);
            array.add((Object)jsonObject3);
        }
        if (StringUtils.isNotEmpty(key4)) {
            JSONObject jsonObject4 = new JSONObject();
            jsonObject4.put((Object)"key", (Object)key4);
            jsonObject4.put((Object)"value", (Object)value4);
            array.add((Object)jsonObject4);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> miniprogram_notice = new HashMap<String, Object>(16);
        miniprogram_notice.put("appid", this.appid);
        miniprogram_notice.put("page", page);
        miniprogram_notice.put("title", title);
        miniprogram_notice.put("description", description);
        miniprogram_notice.put("emphasis_first_item", true);
        miniprogram_notice.put("content_item", array);
        paramMap.put("touser", touser);
        paramMap.put("msgtype", "miniprogram_notice");
        paramMap.put("miniprogram_notice", miniprogram_notice);
        paramMap.put("enable_id_trans", 0);
        paramMap.put("enable_duplicate_check", 0);
        paramMap.put("duplicate_check_interval", 1800);
        System.out.println(JSON.toJSONString(paramMap));
        return this.sendEnterpriseWeChatMessages(JSON.toJSONString(paramMap));
    }
}

