/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTool {
    private static final Logger log = LoggerFactory.getLogger(MysqlTool.class);

    public static File backup(String host, int port, String dbName, String username, String password, String filePath) {
        Long starttime = System.currentTimeMillis();
        try {
            File file = new File(filePath);
            String[] commands = new String[3];
            String os = System.getProperties().getProperty("os.name");
            if (os.startsWith("Win")) {
                commands[0] = "cmd.exe";
                commands[1] = "/c";
            } else {
                commands[0] = "/bin/sh";
                commands[1] = "-c";
            }
            StringBuilder mysqldump = new StringBuilder();
            mysqldump.append("mysqldump");
            mysqldump.append(" --opt");
            mysqldump.append(" --user=").append(username);
            mysqldump.append(" --password=").append(password);
            mysqldump.append(" --host=").append(host);
            mysqldump.append(" --protocol=tcp");
            mysqldump.append(" --port=").append(port);
            mysqldump.append(" --default-character-set=utf8");
            mysqldump.append(" --single-transaction=TRUE");
            mysqldump.append(" --routines");
            mysqldump.append(" --events");
            mysqldump.append(" ").append(dbName);
            mysqldump.append(" > ");
            mysqldump.append("").append(filePath).append("");
            String command = mysqldump.toString();
            System.out.println(command);
            commands[2] = command;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(commands);
            if (process.waitFor() == 0) {
                Long endtime = System.currentTimeMillis();
                Long distance = endtime - starttime;
                System.out.println("\u3010" + dbName + "\u3011\u5907\u4efd\u6210\u529f\uff0c\u8017\u65f6\uff1a" + distance + "ms");
                return file;
            }
            InputStream is = process.getErrorStream();
            if (is != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(is, "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                System.out.println("\u6570\u636e\u5e93\u5907\u3010" + dbName + "\u3011\u4efd\u5931\u8d25\r\n" + sb.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u5907\u3010" + dbName + "\u3011\u4efd\u5931\u8d25", (Throwable)e);
            return null;
        }
        return null;
    }
}

