/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.jpush;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.zhyc.xps.common.cache.CacheManager;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JPushUtil {
    private static final Logger log = LoggerFactory.getLogger(JPushUtil.class);
    @Resource
    CacheManager cacheManager;
    private final String appKey = "c5572e5a4e9b3da2ac4332ee";
    private final String masterSecret = "01235c5e0b77e5aebdd8076d";
    private final boolean apnsProduction = true;
    private JPushClient jPushClient = null;
    private final String jPushPrefix = "push_";

    public void pushToUser(Long accountId, String notificationTitle, String msgTitle, String msgContent, String exts) {
        String registrationID = this.cacheManager.getRegistrationID(accountId);
        ArrayList<String> registrationIDList = new ArrayList<String>();
        registrationIDList.add(registrationID);
        this.sendToRegistrationIDList(registrationIDList, notificationTitle, msgTitle, msgContent, exts);
    }

    public JPushClient getJPushClient() {
        if (this.jPushClient == null) {
            this.jPushClient = new JPushClient("01235c5e0b77e5aebdd8076d", "c5572e5a4e9b3da2ac4332ee");
        }
        return this.jPushClient;
    }

    public void sendToRegistrationIDList(List<String> registrationIDList, String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_all_registrationIDs_alertWithTitle(registrationIDList, notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    public void sendToAliasList(List<String> alias, String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_all_aliasList_alertWithTitle(alias, notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    public void sendToTagsList(List<String> tagsList, String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_all_tagList_alertWithTitle(tagsList, notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    public void sendToAllAndroid(String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_android_all_alertWithTitle(notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    public void sendToAllIOS(String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_ios_all_alertWithTitle(notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    public void sendToAll(String notificationTitle, String msgTitle, String msgContent, String extras) {
        PushPayload pushPayload = this.buildPushObject_android_and_ios(notificationTitle, msgTitle, msgContent, extras);
        this.sendPush(pushPayload);
    }

    private PushResult sendPush(PushPayload pushPayload) {
        log.info("pushPayload={}", (Object)pushPayload);
        PushResult pushResult = null;
        try {
            pushResult = this.getJPushClient().sendPush(pushPayload);
            log.info("" + pushResult);
            if (pushResult.getResponseCode() == 200) {
                log.info("push successful, pushPayload={}", (Object)pushPayload);
            }
        }
        catch (APIConnectionException | APIRequestException e) {
            log.error("push failed: pushPayload={}, exception={}", (Object)pushPayload, (Object)e);
        }
        return pushResult;
    }

    public PushPayload buildPushObject_android_and_ios(String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.all()).setNotification(Notification.newBuilder().setAlert((Object)msgContent).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msgContent).setTitle(msgTitle).addExtra("androidNotification extras key", extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notificationTitle).incrBadge(1).setSound((Object)"default").addExtra("iosNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private PushPayload buildPushObject_all_registrationIDs_alertWithTitle(List<String> registrationIDList, String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.registrationId(registrationIDList)).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msgContent).setTitle(msgTitle).addExtra("androidNotification extras key", extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)msgContent).incrBadge(1).setSound((Object)"default").addExtra("iosNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private PushPayload buildPushObject_all_tagList_alertWithTitle(List<String> tagsList, String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.tag(tagsList)).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msgContent).setTitle(msgTitle).addExtra("androidNotification extras key", extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notificationTitle).incrBadge(1).setSound((Object)"default").addExtra("iosNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private PushPayload buildPushObject_all_aliasList_alertWithTitle(List<String> aliasList, String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias(aliasList)).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)msgContent).setTitle(msgTitle).addExtra("androidNotification extras key", extras)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notificationTitle).incrBadge(1).setSound((Object)"default").addExtra("iosNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private PushPayload buildPushObject_android_all_alertWithTitle(String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)notificationTitle).setTitle(notificationTitle).addExtra("androidNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }

    private PushPayload buildPushObject_ios_all_alertWithTitle(String notificationTitle, String msgTitle, String msgContent, String extras) {
        return PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.all()).setNotification(Notification.newBuilder().addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)notificationTitle).incrBadge(1).setSound((Object)"default").addExtra("iosNotification extras key", extras)).build()).build()).setMessage(Message.newBuilder().setMsgContent(msgContent).setTitle(msgTitle).addExtra("message extras key", extras).build()).setOptions(Options.newBuilder().setApnsProduction(true).setSendno(1).setTimeToLive(86400L).build()).build();
    }
}

