/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.minio;

import com.zhyc.xps.common.utils.ContentTypeUtil;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioClientUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioClientUtil.class);
    @Value(value="${minio.endpoint}")
    private String minioEndpoint;
    @Value(value="${minio.accesskey}")
    private String minioAccessKey;
    @Value(value="${minio.secretkey}")
    private String minioSecretKey;

    public String upload(String bucket, String objectKey, MultipartFile file) throws Exception {
        String fileTitle = file.getOriginalFilename();
        if (fileTitle.isEmpty()) {
            return "";
        }
        String fileExt = fileTitle.substring(fileTitle.lastIndexOf(46));
        String szContentType = ContentTypeUtil.getContentType(fileExt);
        if (szContentType == null || szContentType.isEmpty()) {
            szContentType = "application/octet-stream";
        }
        return this.uploadInputStream(bucket, objectKey, file.getInputStream(), szContentType);
    }

    private String uploadInputStream(String bucket, String objectKey, InputStream inputStream, String ext) throws Exception {
        MinioClient client = MinioClient.builder().endpoint(this.minioEndpoint).credentials(this.minioAccessKey, this.minioSecretKey).build();
        client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).object(objectKey)).stream(inputStream, (long)inputStream.available(), -1L).contentType(ext).build());
        return String.format("%s/%s/%s", this.minioEndpoint, bucket, objectKey);
    }
}

