/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.mqtt;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.zhyc.xps.common.utils.mqtt.MqttProviderCallBack;
import jakarta.annotation.PostConstruct;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqttUtil {
    private static final Logger log = LoggerFactory.getLogger(MqttUtil.class);
    @Value(value="${mqtt.server}")
    private String hostUrl;
    @Value(value="${mqtt.username}")
    private String username;
    @Value(value="${mqtt.password}")
    private String password;
    @Value(value="${mqtt.client.id}")
    private String clientId;
    @Value(value="${mqtt.default.topic}")
    private String defaultTopic;
    private MqttClient client;

    public void connect() {
        try {
            this.client = new MqttClient(this.hostUrl, this.clientId, (MqttClientPersistence)new MemoryPersistence());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setCleanSession(true);
            options.setUserName(this.username);
            options.setPassword(this.password.toCharArray());
            options.setConnectionTimeout(100);
            options.setKeepAliveInterval(20);
            options.setWill("willTopic", (this.clientId + "\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5").getBytes(), 0, false);
            options.setAutomaticReconnect(true);
            this.client.setCallback((MqttCallback)new MqttProviderCallBack());
            this.client.connect(options);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void init() {
        this.connect();
    }

    public void publish(String topic, Object object) {
        String data = JSONObject.toJSONString((Object)object, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        try {
            MqttMessage message = new MqttMessage();
            message.setQos(1);
            message.setRetained(false);
            message.setPayload(data.getBytes());
            this.client.publish(topic, message);
        }
        catch (MqttException e) {
            log.error(e.toString());
        }
    }

    public void subscribe(String topic, IMqttMessageListener listener) {
        try {
            this.client.subscribe(topic, listener);
        }
        catch (MqttException e) {
            log.error(e.toString());
        }
    }
}

