/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.GoafCheckDef;
import com.zhyc.xps.goaf.service.GoafCheckDefService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafcheckdef"})
public class GoafCheckDefController
extends BaseController {
    @Resource
    GoafCheckDefService goafCheckDefService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafCheckDefByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafCheckDef> data = this.goafCheckDefService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafCheckDefBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafCheckDef> data = this.goafCheckDefService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{jobId}"})
    public JsonResult getByjobId(@PathVariable Long jobId) {
        Long ocId = this.getCurOcId();
        List<GoafCheckDef> goafCheckDeflist = this.goafCheckDefService.getByjobId(ocId, jobId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafCheckDeflist);
    }

    @GetMapping(value={"/{checkDefId}"})
    public JsonResult getGoafCheckDefById(@PathVariable Long checkDefId) {
        GoafCheckDef goafCheckDef = this.goafCheckDefService.getBycheckDefId(checkDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)goafCheckDef);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafCheckDef(@RequestBody GoafCheckDef goafCheckDef) throws Exception {
        Long ocId = this.getCurOcId();
        goafCheckDef.setOcId(ocId);
        try {
            this.goafCheckDefService.create(goafCheckDef);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafCheckDef(@RequestBody GoafCheckDef goafCheckDef) throws Exception {
        try {
            this.goafCheckDefService.update(goafCheckDef);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{checkDefId}"})
    public JsonResult deleteGoafCheckDefById(@PathVariable Long checkDefId) throws Exception {
        try {
            this.goafCheckDefService.delete(checkDefId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

