/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.dto.GoafDevSensorDataDto;
import com.zhyc.xps.goaf.dto.GoafDevSensorOverviewDto;
import com.zhyc.xps.goaf.entity.GoafDevInfo;
import com.zhyc.xps.goaf.mapper.GoafSensorMapper;
import com.zhyc.xps.goaf.service.GoafDevInfoService;
import com.zhyc.xps.goaf.service.GoafSensorDataService;
import com.zhyc.xps.goaf.vo.DevStatisVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafdevinfo"})
public class GoafDevInfoController
extends BaseController {
    @Resource
    GoafDevInfoService goafDevInfoService;
    @Resource
    GoafSensorDataService goafSensorDataService;
    @Resource
    GoafSensorMapper goafSensorMapper;

    @GetMapping(value={"/list"})
    public JsonResult getGoafDevInfoByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafDevInfo> data = this.goafDevInfoService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafDevInfoBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafDevInfo> data = this.goafDevInfoService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/goafdevsensoroverview/list"})
    public JsonResult getGoafDevOverviewByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafDevSensorOverviewDto> data = this.goafDevInfoService.getGoafDevOverviewByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/goafdevsensoroverview/page"})
    public PageResult getGoafDevOverviewByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafDevSensorOverviewDto> data = this.goafDevInfoService.getGoafDevOverviewByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/goafdevsensordata/list"})
    public JsonResult getGoafDevSensorDataByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafDevSensorDataDto> data = this.goafDevInfoService.getGoafDevSensorDataByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/goafdevsensordata/page"})
    public PageResult getGoafDevSensorDataByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafDevSensorDataDto> data = this.goafDevInfoService.getGoafDevSensorDataByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{goafDevId}"})
    public JsonResult getGoafDevInfoById(@PathVariable Long goafDevId) {
        GoafDevInfo goafDevInfo = this.goafDevInfoService.getByGoafDevId(goafDevId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafDevInfo);
    }

    @GetMapping(value={"/goafdevstatis"})
    public JsonResult goafdevstatis() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        DevStatisVo devStatisVo = this.goafDevInfoService.getStatisNum(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", devStatisVo);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafDevInfo(@RequestBody GoafDevInfo goafDevInfo) throws Exception {
        Long ocId = this.getCurOcId();
        goafDevInfo.setOcId(ocId);
        try {
            this.goafDevInfoService.create(goafDevInfo);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafDevInfo(@RequestBody GoafDevInfo goafDevInfo) throws Exception {
        try {
            this.goafDevInfoService.update(goafDevInfo);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{goafDevId}"})
    public JsonResult deleteGoafDevInfoById(@PathVariable Long goafDevId) throws Exception {
        try {
            this.goafDevInfoService.delete(goafDevId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

