/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.dto.GoafMapDto;
import com.zhyc.xps.goaf.service.GoafMapFlayerService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafmapflayer"})
public class GoafMapFlayerController
extends BaseController {
    @Resource
    GoafMapFlayerService goafMapFlayerService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafMapFlayerByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafMapDto> data = this.goafMapFlayerService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafMapFlayerBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafMapDto> data = this.goafMapFlayerService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{goaflayerId}"})
    public JsonResult getGoafMapFlayerById(@PathVariable Long goaflayerId) {
        GoafMapDto goafMapDto = this.goafMapFlayerService.getById(goaflayerId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafMapDto);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafMapFlayer(@RequestBody GoafMapDto goafMapDto) throws Exception {
        Long ocId = this.getCurOcId();
        goafMapDto.setOcId(ocId);
        Long goafId = goafMapDto.getGoafId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("goafId", goafId);
        List<GoafMapDto> goafMapDtoList = this.goafMapFlayerService.getByList(map);
        if (null != goafMapDtoList && goafMapDtoList.size() > 0) {
            return this.resultErr("\u9519\u8bef\uff1a\u8be5\u91c7\u7a7a\u533a\u5df2\u7ecf\u8bbe\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e\uff01");
        }
        try {
            this.goafMapFlayerService.create(goafMapDto);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafMapFlayer(@RequestBody GoafMapDto goafMapDto) throws Exception {
        try {
            this.goafMapFlayerService.update(goafMapDto);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{goaflayerId}/{mapId}/{layerId}"})
    public JsonResult deleteGoafMapFlayerById(@PathVariable Long goaflayerId, @PathVariable Long mapId, @PathVariable Long layerId) throws Exception {
        Long ocId = this.getCurOcId();
        try {
            this.goafMapFlayerService.delete(ocId, goaflayerId, mapId, layerId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

