/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.GoafSensor;
import com.zhyc.xps.goaf.service.GoafSensorService;
import com.zhyc.xps.goaf.vo.DevStatisVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafsensor"})
public class GoafSensorController
extends BaseController {
    @Resource
    GoafSensorService goafSensorService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafSensorByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafSensor> data = this.goafSensorService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafSensorBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafSensor> data = this.goafSensorService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{goafSensorId}"})
    public JsonResult getGoafSensorById(@PathVariable Long goafSensorId) {
        GoafSensor goafSensor = this.goafSensorService.getByGoafSensorId(goafSensorId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafSensor);
    }

    @GetMapping(value={"/goafdevstatis"})
    public JsonResult goafdevstatis() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        DevStatisVo devStatisVo = this.goafSensorService.getStatisNum(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", devStatisVo);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafSensor(@RequestBody GoafSensor goafSensor) throws Exception {
        Long ocId = this.getCurOcId();
        goafSensor.setOcId(ocId);
        try {
            this.goafSensorService.create(goafSensor);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafSensor(@RequestBody GoafSensor goafSensor) throws Exception {
        try {
            this.goafSensorService.update(goafSensor);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{goafDevId}"})
    public JsonResult deleteGoafSensorById(@PathVariable Long goafDevId) throws Exception {
        try {
            this.goafSensorService.delete(goafDevId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

