/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.utils.mqtt.MqttUtil;
import com.zhyc.xps.goaf.entity.GoafSensorData;
import com.zhyc.xps.goaf.service.GoafDevInfoService;
import com.zhyc.xps.goaf.service.GoafSensorDataService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/sensordata"})
public class GoafSensorDataController
extends BaseController {
    @Resource
    GoafSensorDataService goafSensorDataService;
    @Resource
    GoafDevInfoService goafDevInfoService;
    @Resource
    MqttUtil mqttUtil;

    @GetMapping(value={"/list"})
    public JsonResult getGoafSensorDataByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafSensorData> data = this.goafSensorDataService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafSensorDataBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafSensorData> data = this.goafSensorDataService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/newsensordata"})
    public JsonResult getGoafSensorDataByNew(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        GoafSensorData data = this.goafSensorDataService.getByNew(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/wavedata/{goafdataid}"})
    public JsonResult getWavebyDataId(@PathVariable Long goafdataid) {
        GoafSensorData data = this.goafSensorDataService.getWavebyDataId(goafdataid);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }
}

