/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.GoafCheckRecord;
import com.zhyc.xps.goaf.entity.GoafTask;
import com.zhyc.xps.goaf.service.GoafCheckRecordService;
import com.zhyc.xps.goaf.service.GoafTaskService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goaftask"})
public class GoafTaskController
extends BaseController {
    @Resource
    GoafTaskService goafTaskService;
    @Resource
    GoafCheckRecordService goafCheckRecordService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafTaskByList(@RequestParam Map<String, Object> map) {
        Long status;
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        if (null != map.get("status") && 1L == (status = Long.valueOf("0" + map.get("status")))) {
            List<GoafCheckRecord> data = this.goafCheckRecordService.getByList(map);
            return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
        }
        List<GoafTask> data = this.goafTaskService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafTaskBypage(@RequestParam Map<String, Object> map) {
        Long status;
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        if (null != map.get("status") && 1L == (status = Long.valueOf("0" + map.get("status")))) {
            PageBean<GoafCheckRecord> data = this.goafCheckRecordService.getByPage(map);
            return this.pageResult(data);
        }
        PageBean<GoafTask> data = this.goafTaskService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{taskId}"})
    public JsonResult getGoafTaskById(@PathVariable Long taskId) {
        GoafTask goafTask = this.goafTaskService.getBytaskId(taskId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafTask);
    }

    @PostMapping(value={"/completed"})
    public JsonResult createGoafTask(@RequestBody GoafTask goafTask) throws Exception {
        try {
            this.goafTaskService.completed(goafTask);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{taskId}"})
    public JsonResult deleteGoafTaskById(@PathVariable Long taskId) throws Exception {
        try {
            this.goafTaskService.delete(taskId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

